/*
 * Decompiled with CFR 0.152.
 */
package primitive;

import io.AwkLike;
import io.fileload;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import primitive.HaplotypeFrequency;
import primitive.SnpData;

public class Snp_DataReader {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        String[] data1 = fileload.loadLine0(args[0]);
        char[][] nucleotides = new char[data1.length][];
        int j = 0;
        while (j < data1.length) {
            SnpData data = Snp_DataReader.DataReaderSetData(data1[j], 2);
            nucleotides[j] = data.SNPdata;
            int h = 0;
            while (h < nucleotides[j].length) {
                System.out.print("\t");
                System.out.print(nucleotides[j][h]);
                ++h;
            }
            System.out.println();
            ++j;
        }
    }

    public static SnpData DataReaderSetData(String dataString, int dataType) {
        try {
            switch (dataType) {
                case 0: {
                    return Snp_DataReader.DataReaderSetHapmapData(dataString);
                }
                case 1: {
                    return Snp_DataReader.DataReaderSetHaplotypeData(dataString);
                }
                case 2: {
                    return Snp_DataReader.DataReaderSetPhasingHapmapData(dataString);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SnpData();
    }

    static SnpData DataReaderSetHapmapData(String dataString) {
        AwkLike a = new AwkLike(dataString);
        int size = a.NF();
        SnpData result = new SnpData();
        result.rsNumber = a.doller(1);
        result.SNPalleles = a.doller(2);
        result.chrom = a.doller(3);
        result.pos = new Long(a.doller(4));
        Vector<String> v = new Vector<String>();
        int i = 12;
        while (i <= size) {
            v.add(a.doller(i));
            ++i;
        }
        int SNP_DATA_LEN = v.size() * 2;
        char[] SNPdata = new char[SNP_DATA_LEN];
        int i2 = 0;
        while (i2 < SNP_DATA_LEN) {
            SNPdata[2 * i2] = ((String)v.elementAt(i2)).charAt(0);
            SNPdata[2 * i2 + 1] = ((String)v.elementAt(i2)).charAt(1);
            ++i2;
        }
        result.SNPdata = SNPdata;
        return result;
    }

    static SnpData DataReaderSetHaplotypeData(String dataString) {
        AwkLike a = new AwkLike(dataString);
        int size = a.NF();
        SnpData result = new SnpData();
        result.rsNumber = a.doller(1);
        result.SNPalleles = a.doller(6);
        result.chrom = a.doller(3);
        result.pos = new Long(a.doller(5));
        Vector<String> v = new Vector<String>();
        int i = 7;
        while (i <= size) {
            v.add(a.doller(i));
            ++i;
        }
        int SNP_DATA_LEN = v.size();
        char[] SNPdata = new char[SNP_DATA_LEN];
        int i2 = 0;
        while (i2 < SNP_DATA_LEN) {
            SNPdata[i2] = ((String)v.elementAt(i2)).charAt(0);
            ++i2;
        }
        result.SNPdata = SNPdata;
        return result;
    }

    static SnpData DataReaderSetPhasingHapmapData(String dataString) {
        AwkLike a = new AwkLike(dataString);
        int size = a.NF();
        SnpData result = new SnpData();
        result.rsNumber = a.doller(1);
        result.pos = new Long(a.doller(2));
        Vector<String> v = new Vector<String>();
        int i = 3;
        while (i <= size) {
            v.add(a.doller(i));
            ++i;
        }
        int SNP_DATA_LEN = v.size();
        char[] SNPdata = new char[SNP_DATA_LEN];
        int i2 = 0;
        while (i2 < SNP_DATA_LEN) {
            SNPdata[i2] = ((String)v.elementAt(i2)).charAt(0);
            ++i2;
        }
        result.SNPdata = SNPdata;
        return result;
    }

    public static SnpData[][] DataReaderMakeParallelData(SnpData[] snpTmpData1, SnpData[] snpTmpData2) {
        long index = 0L;
        int caseIndex = 0;
        int controlIndex = 0;
        long line1 = snpTmpData1.length;
        long line2 = snpTmpData2.length;
        Vector<SnpData> snpData1 = new Vector<SnpData>();
        Vector<SnpData> snpData2 = new Vector<SnpData>();
        try {
            while ((long)caseIndex < line1 || (long)controlIndex < line2) {
                if (snpTmpData1[caseIndex].pos == snpTmpData2[controlIndex].pos) {
                    snpData1.add(snpTmpData1[caseIndex]);
                    snpData2.add(snpTmpData2[controlIndex]);
                    ++index;
                    ++caseIndex;
                    ++controlIndex;
                    continue;
                }
                if (snpTmpData1[caseIndex].pos < snpTmpData2[controlIndex].pos) {
                    ++caseIndex;
                    continue;
                }
                if (snpTmpData1[caseIndex].pos <= snpTmpData2[controlIndex].pos) continue;
                ++controlIndex;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        SnpData[][] result = new SnpData[2][];
        int dataCount = snpData1.size();
        result[0] = new SnpData[dataCount];
        result[1] = new SnpData[dataCount];
        int j = 0;
        while (j < dataCount) {
            result[0][j] = (SnpData)snpData1.elementAt(j);
            result[1][j] = (SnpData)snpData2.elementAt(j);
            ++j;
        }
        return result;
    }

    public static char maximumNuc(SnpData snpData) {
        char[] SNPdata = snpData.SNPdata;
        int[] count = new int[5];
        char[] nuc = new char[]{'N', 'T', 'C', 'A', 'G'};
        int h = 0;
        while (h < SNPdata.length) {
            int tmp = 0;
            switch (SNPdata[h]) {
                case 'u': {
                    tmp = 1;
                    break;
                }
                case 'U': {
                    tmp = 1;
                    break;
                }
                case 'T': {
                    tmp = 1;
                    break;
                }
                case 't': {
                    tmp = 1;
                    break;
                }
                case 'C': {
                    tmp = 2;
                    break;
                }
                case 'c': {
                    tmp = 2;
                    break;
                }
                case 'A': {
                    tmp = 3;
                    break;
                }
                case 'a': {
                    tmp = 3;
                    break;
                }
                case 'G': {
                    tmp = 4;
                    break;
                }
                case 'g': {
                    tmp = 4;
                }
            }
            int n = tmp;
            count[n] = count[n] + 1;
            ++h;
        }
        int max = 0;
        int maxi = 0;
        int tmp = 1;
        while (tmp < 5) {
            if (max < count[tmp]) {
                max = count[tmp];
                maxi = tmp;
            }
            ++tmp;
        }
        return nuc[maxi];
    }

    public static int[] genotype(SnpData snpData, char reference) {
        char[] SNPdata = snpData.SNPdata;
        int[] result = new int[SNPdata.length];
        int h = 0;
        while (h < SNPdata.length) {
            result[h] = SNPdata[h] == reference ? 0 : 1;
            ++h;
        }
        return result;
    }

    public static int[][] DataReaderMakeTable(SnpData snpData1, SnpData snpData2, int[] d) {
        char reference = Snp_DataReader.maximumNuc(snpData1);
        int[] data1 = Snp_DataReader.genotype(snpData1, reference);
        int[] data2 = Snp_DataReader.genotype(snpData2, reference);
        int[] data = new int[data1.length + data2.length];
        int h = 0;
        while (h < data1.length) {
            data[h] = data1[h];
            ++h;
        }
        h = 0;
        while (h < data2.length) {
            data[h + data1.length] = data2[h];
            ++h;
        }
        int len = data.length;
        int[][] T = new int[2][2];
        int h2 = 0;
        while (h2 < len) {
            int[] nArray = T[d[h2]];
            int n = data[h2];
            nArray[n] = nArray[n] + 1;
            ++h2;
        }
        return T;
    }

    public static int[] populationType(SnpData snpData1, SnpData snpData2) {
        int len1 = snpData1.SNPdata.length;
        int len2 = snpData2.SNPdata.length;
        int[] data = new int[len1 + len2];
        int h = 0;
        while (h < len1) {
            data[h] = 0;
            ++h;
        }
        h = 0;
        while (h < len2) {
            data[h + len1] = 1;
            ++h;
        }
        return data;
    }

    public static HaplotypeFrequency[] haplotypeFrequency(SnpData[][] snpData) {
        int popNumber = snpData.length;
        String[][] sequences = new String[popNumber][];
        Vector<HaplotypeFrequency> haplotypeList = new Vector<HaplotypeFrequency>();
        int maxHaplotypeNumber = 0;
        int i = 0;
        while (i < popNumber) {
            sequences[i] = Snp_DataReader.sequences(snpData[i]);
            maxHaplotypeNumber += sequences[i].length;
            ++i;
        }
        String[] allSNP = new String[maxHaplotypeNumber];
        int tmp = 0;
        int i2 = 0;
        while (i2 < popNumber) {
            int i22 = 0;
            while (i22 < sequences[i2].length) {
                allSNP[tmp] = sequences[i2][i22];
                ++tmp;
                ++i22;
            }
            ++i2;
        }
        int h = 0;
        while (h < maxHaplotypeNumber) {
            String haplotype = allSNP[h].toString();
            int size = haplotypeList.size();
            boolean flag = false;
            int h2 = 0;
            while (h2 < size) {
                if (haplotype.equals(((HaplotypeFrequency)haplotypeList.elementAt((int)h2)).haplotype)) {
                    ++((HaplotypeFrequency)haplotypeList.elementAt((int)h2)).count;
                    flag = true;
                }
                ++h2;
            }
            if (!flag) {
                haplotypeList.add(new HaplotypeFrequency(haplotype));
            }
            ++h;
        }
        int size = haplotypeList.size();
        HaplotypeFrequency[] result = new HaplotypeFrequency[size];
        int h2 = 0;
        while (h2 < size) {
            result[h2] = (HaplotypeFrequency)haplotypeList.elementAt(h2);
            ++h2;
        }
        return result;
    }

    public static String[] sequences(SnpData[] snpData1) {
        int h;
        int m = snpData1.length;
        int maxHaplotypeNumber = snpData1[0].SNPdata.length;
        StringBuffer[] allSNP = new StringBuffer[maxHaplotypeNumber];
        int h2 = 0;
        while (h2 < maxHaplotypeNumber) {
            allSNP[h2] = new StringBuffer();
            ++h2;
        }
        int j = 0;
        while (j < m) {
            h = 0;
            while (h < maxHaplotypeNumber) {
                allSNP[h].append(snpData1[j].SNPdata[h]);
                ++h;
            }
            ++j;
        }
        String[] result = new String[maxHaplotypeNumber];
        h = 0;
        while (h < maxHaplotypeNumber) {
            result[h] = allSNP[h].toString();
            ++h;
        }
        return result;
    }

    public static SnpData[] sequenceToSnpData(String[] sequences) {
        int seqLen = sequences[0].length();
        SnpData[] result = new SnpData[seqLen];
        int size = sequences.length;
        int j = 0;
        while (j < seqLen) {
            result[j] = new SnpData();
            result[j].SNPdata = new char[size];
            result[j].pos = j;
            int h = 0;
            while (h < size) {
                result[j].SNPdata[h] = sequences[h].charAt(j);
                ++h;
            }
            ++j;
        }
        return result;
    }
}

