/*
 * Decompiled with CFR 0.152.
 */
package probability;

import probability.Bunkai;
import probability.Factorial;

public class Keisan4 {
    public static double threshold = 6.635;
    public static int haba = 100;

    public static void main(String[] args) {
        int samplesize = new Integer(args[0]);
        long time = System.currentTimeMillis();
        double[] h = new double[]{0.55232887, 0.179332453, 0.167452385, 0.039600226, 0.061286064};
        int L = h.length;
        Factorial f = new Factorial(samplesize * 2);
        int[] lower = new int[L];
        int[] upper = new int[L];
        int[] range = new int[L];
        int i = 0;
        while (i < L) {
            lower[i] = Keisan4.lowerLimit(samplesize, h[i], haba);
            upper[i] = Keisan4.upperLimit(samplesize, h[i], haba);
            range[i] = upper[i] - lower[i] + 1;
            ++i;
        }
        double total = 0.0;
        boolean count = false;
        Bunkai b = new Bunkai(lower, upper, samplesize);
        while (!b.done()) {
            int[] result = b.bunkai();
            int[][] X = new int[1][L];
            int i2 = 0;
            while (i2 < result.length) {
                X[0][i2] = result[i2];
                ++i2;
            }
            if (Keisan4.significant(samplesize, X[0], h) == 0) {
                total += Keisan4.multinomialP(samplesize, X[0], h, f);
            }
            b.count();
        }
        System.out.print(samplesize);
        System.out.print("\t");
        System.out.print(L);
        System.out.print("\t");
        System.out.print(1.0 - total);
        System.out.print("\t");
        System.out.println((System.currentTimeMillis() - time) / 1000L);
    }

    public static double multinomialP(int size, int[] X, double[] h, Factorial fact) {
        int L = X.length;
        double logResult = fact.logFactrial(size);
        int i = 0;
        while (i < L) {
            logResult -= fact.logFactrial(X[i]);
            logResult += Math.log(h[i]) * (double)X[i];
            ++i;
        }
        return Math.exp(logResult);
    }

    public static int upperLimit(int sampleSize, double frequency, int haba) {
        double x = Math.sqrt(threshold * (double)sampleSize * frequency);
        int n = (int)((double)sampleSize * frequency + x) + haba;
        if (n < sampleSize) {
            return n;
        }
        return sampleSize;
    }

    public static int lowerLimit(int sampleSize, double frequency, int haba) {
        double x = Math.sqrt(threshold * (double)sampleSize * frequency);
        int n = (int)((double)sampleSize * frequency - x) - haba;
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    public static int significant(int sampleSize, int[] obs, double[] frequency) {
        int result = 0;
        int i = 0;
        while (i < obs.length) {
            if (Keisan4.significant(sampleSize, obs[i], frequency[i]) == 1) {
                result = 1;
            }
            ++i;
        }
        return result;
    }

    public static int significant(int sampleSize, int obs, double frequency) {
        double exp = (double)sampleSize * frequency;
        double chi2 = ((double)obs - exp) * ((double)obs - exp) / exp;
        if (chi2 > threshold) {
            return 1;
        }
        return 0;
    }
}

