#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "snp_DataReader.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"

/**********************/
/* ϥե򳫤 */
/**********************/
int InputFileOpen(FILE **fp, char *file)
{
    int retval = 0;

    /* ե륪ץ */
    *fp = fopen(file, "r");
    if (NULL == *fp){
        printf("input file open error! FileName:%s\n", file);
        retval = 1;
    }

    return retval;
}

/**********************/
/* ϥե򳫤 */
/**********************/
int OutputFileOpen(FILE **fp, char *file)
{
    int retval = 0;

    /* ե륪ץ */
    *fp = fopen(file, "w");
    if (NULL == *fp){
        printf("output file open error! FileName:%s\n", file);
        retval = 1;
    }

    return retval;
}

/********************/
/* եĤ */
/********************/
void FileClose(FILE *fp)
{
    if (fp != NULL){
        fclose(fp);
    }
}


/********************************/
/* եιԿ򥫥Ȥ */
/********************************/
long DataReaderCountFileLine(FILE *fp)
{
    long index = 0;
    long count = 0;
    char buf[MAX_LEN];

    /* ʸɤ߹ */
    while ( fgets(buf, MAX_LEN, fp) != NULL ){
        index = strlen(buf);
        if ('\n' == buf[index-1]){
            count++;
        }
    }

    return count;
}

/********************************/
/* ϥǡ¤Τ˼ */
/********************************/
int DataReaderSetAllData(FILE *fp, SnpData *snpData, long line, int dataType)
{
    int retval = 0;

    switch(dataType){
        case 0:
            /* ϥǡHapmap */
            retval = DataReaderSetAllHapmapData(fp, snpData, line);
            break;
        case 1:
            /* ϥǡHaplotypeData */
            retval = DataReaderSetAllHaplotypeData(fp, snpData, line);
            break;
        case 2:
            /* ϥǡPhasingHapmap */
            retval = DataReaderSetAllPhasingHapmapData(fp, snpData, line);
            break;
        default:
            break;
    }
    return retval;
}

/********************************/
/* ϥǡԤ¤Τ˼ */
/********************************/
int DataReaderSetData(FILE *fp, SnpData *snpData, long line, int dataType)
{
    int retval = 0;

    switch(dataType){
        case 0:
            /* ϥǡHapmap */
            retval = DataReaderSetHapmapData(fp, snpData, line);
            break;
        case 1:
            /* ϥǡHaplotypeData */
            retval = DataReaderSetHaplotypeData(fp, snpData, line);
            break;
        case 2:
            /* ϥǡPhasingHapmap */
            retval = DataReaderSetPhasingHapmapData(fp, snpData, line);
            break;
        default:
            break;
    }
    return retval;
}

/********************************/
/* Hapmapǡ¤Τ˼ */
/********************************/
int DataReaderSetAllHapmapData(FILE *fp, SnpData *snpData, long line)
{
    int retval = 0;
    long i = 0;
    long sampleNum = 0;

    /* HapmapDataΥץ */
    sampleNum = DataReaderGetHapmapSampleNum(fp);
    /* ե뤫ɤ߹ */
    for (i = 1; i < line; i++){
        /* SNPǡǼΥ */
        snpData[i].SNPdata = (char*)malloc1Dim(sizeof(char), sampleNum);
        retval = DataReaderSetHapmapData(fp, &snpData[i], i);
    }

    return retval;
}

/************************************/
/* HapmapǡԤ¤Τ˼ */
/************************************/
int DataReaderSetHapmapData(FILE *fp, SnpData *snpData, long line)
{
    int i = 0;
    int retval = -1;    /* եǸޤƤ-1֤ */
    int character = 0;
    int column = 1;     /* Hapmapǡ */
    int refNum = 0;     /* SNPallelesΥѥ */
    int index = 0;
    int dataIndex = 0;
    char tmp[20];

    /* ¤Τν */
    snpData->missingDataCount = 0;
    snpData->SNPallelesCount[0] = 0;
    snpData->SNPallelesCount[1] = 0;
    snpData->SNPallelesCount[2] = 0;

    /* ʸɤ߹ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* ɤ߹ͤݻƽλ */
        if ('\n' == character){
            snpData->dataNum = dataIndex;
            snpData->allelesNum = refNum;
            retval = 0;
            dataIndex = 0;
            break;
        }
        /* եΣܰʹߤԤ */
        else if (line > 0){
            /* ե򥫥 */
            if (isspace(character) != 0){
                if (HAPMAP_RS_NUM == column){
                    snpData->rsNumber[index] = '\0';
                }
                else if (HAPMAP_POS == column){
                    tmp[index] = '\0';
                    snpData->pos = atol(tmp);
                }
                else if (HAPMAP_CHROM == column){
                    snpData->chrom[index] = '\0';
                }
                column++;
                index = 0;
            }
            /* rs# */
            else if (HAPMAP_RS_NUM == column){
                if (isalnum(character) != 0){
                    snpData->rsNumber[index] = character;
                    index++;
                }
            }
            /* SNPallels */
            else if (HAPMAP_ALLELES == column){
                if (isalpha(character) != 0){
                    snpData->SNPalleles[refNum] = character;
                    refNum++;
                }
            }
            /* chrom */
            else if (HAPMAP_CHROM == column){
                if (isalnum(character) != 0){
                    snpData->chrom[index] = character;
                    index++;
                }
            }
            /* pos */
            else if (HAPMAP_POS == column){
                tmp[index] = character;
                index++;
            }
            /* 12ܹܰԤΥǡ򻲾Ȥ */
            else if (column >= HAPMAP_DATA){
                for (i = 0; i < refNum; i++){
                    /* SNPallelesȰפǡ򥫥 */
                    if (snpData->SNPalleles[i] == character){
                        snpData->SNPallelesCount[i]++;
                    }
                }
                /* NȰפǡ򥫥 */
                if ('N' == character){
                    snpData->missingDataCount++;
                }
                /* ҥǡǼ */
                snpData->SNPdata[dataIndex] = character;
                dataIndex++;
            }
        }
    }
    return retval;
}

/*********************************/
/* HaplotypeData¤Τ˼ */
/*********************************/
int DataReaderSetAllHaplotypeData(FILE *fp, SnpData *snpData, long line)
{
    int retval = 0;
    long i = 0;
    long sampleNum = 0;


    /* HaplotypeǡΥץ */
    sampleNum = DataReaderGetHaplotypeSampleNum(fp);
    for (i = 1; i < line; i++){
        /* SNPǡǼΥ */
        snpData[i].SNPdata = (char*)malloc1Dim(sizeof(char), sampleNum);
        retval = DataReaderSetHaplotypeData(fp, &snpData[i], i);
    }

    return retval;
}

/*************************************/
/* HaplotypeDataԤ¤Τ˼ */
/*************************************/
int DataReaderSetHaplotypeData(FILE *fp, SnpData *snpData, long line)
{
    int i = 0;
    int retval = -1;    /* եǸޤƤ-1֤ */
    int character = 0;
    int column = 1;     /* Haplotypeǡ */
    int refNum = 0;     /* SNPallelesΥѥ */
    int index = 0;
    int dataIndex = 0;
    char tmp[20];

    /* ¤Τν */
    snpData->missingDataCount = 0;
    snpData->SNPallelesCount[0] = 0;
    snpData->SNPallelesCount[1] = 0;
    snpData->SNPallelesCount[2] = 0;

    /* ʸɤ߹ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* ɤ߹ͤݻƽλ */
        if ('\n' == character){
            snpData->dataNum = dataIndex;
            snpData->allelesNum = refNum;
            retval = 0;
            dataIndex = 0;
            break;
        }
        /* եΣܰʹߤԤ */
        else if (line > 0){
            /* ե򥫥 */
            if (isspace(character) != 0){
                if (HAPLOTYPE_RS_NUM == column){
                    snpData->rsNumber[index] = '\0';
                }
                else if (HAPLOTYPE_POS == column){
                    tmp[index] = '\0';
                    snpData->pos = atol(tmp);
                }
                else if (HAPLOTYPE_CHROM == column){
                    snpData->chrom[index] = '\0';
                }
                column++;
                index = 0;
            }
            /* rs# */
            else if (HAPLOTYPE_RS_NUM == column){
                if (isalnum(character) != 0){
                    snpData->rsNumber[index] = character;
                    index++;
                }
            }
            /* SNPallels */
            else if (HAPLOTYPE_ALLELES == column){
                if (isalpha(character) != 0){
                    snpData->SNPalleles[refNum] = character;
                    refNum++;
                }
            }
            /* chrom */
            else if (HAPLOTYPE_CHROM == column){
                if (isalnum(character) != 0){
                    snpData->chrom[index] = character;
                    index++;
                }
            }
            /* pos */
            else if (HAPLOTYPE_POS == column){
                tmp[index] = character;
                index++;
            }
            /* 7ܹܰԤΥǡ򻲾Ȥ */
            else if (column >= HAPLOTYPE_DATA){
                for (i = 0; i < refNum; i++){
                    /* SNPallelesȰפǡ򥫥 */
                    if (snpData->SNPalleles[i] == character){
                        snpData->SNPallelesCount[i]++;
                    }
                }
                /* NȰפǡ򥫥 */
                if ('N' == character){
                    snpData->missingDataCount++;
                }
                /* ҥǡǼ */
                snpData->SNPdata[dataIndex] = character;
                dataIndex++;
            }
        }
    }
    return retval;
}

/*********************************************/
/* phasing줿Hapmapǡ¤Τ˼ */
/*********************************************/
int DataReaderSetAllPhasingHapmapData(FILE *fp, SnpData *snpData, long line)
{
    int retval = 0;
    long i = 0;
    long sampleNum = 0;

    /* phasing줿HapmapǡΥץ */
    sampleNum = DataReaderGetPhasingHapmapSampleNum(fp);
    /* ե뤫ɤ߹ */
    for (i = 1; i < line; i++){
        /* SNPǡǼΥ */
        snpData[i].SNPdata = (char*)malloc1Dim(sizeof(char), sampleNum);
        retval = DataReaderSetPhasingHapmapData(fp, &snpData[i], i);
    }

    return retval;
}

/*************************************************/
/* phasing줿HapmapǡԤ¤Τ˼ */
/*************************************************/
int DataReaderSetPhasingHapmapData(FILE *fp, SnpData *snpData, long line)
{
    int i = 0;
    int retval = -1;    /* եǸޤƤ-1֤ */
    int character = 0;
    int column = 1;     /* ǡ */
    int refNum = 0;     /* SNPallelesΥѥ */
    int index = 0;
    int dataIndex = 0;
    int flag = 0;
    char tmp[20];

    /* ¤Τν */
    snpData->missingDataCount = 0;
    snpData->SNPallelesCount[0] = 0;
    snpData->SNPallelesCount[1] = 0;
    snpData->SNPallelesCount[2] = 0;

    /* chrom */
    strcpy(snpData->chrom, "----");

    /* ʸɤ߹ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* ɤ߹ͤݻƽλ */
        if ('\n' == character){
            snpData->dataNum = dataIndex;
            snpData->allelesNum = refNum;
            retval = 0;
            dataIndex = 0;
            break;
        }
        /* եΣܰʹߤԤ */
        else if (line > 0){
            /* ե򥫥 */
            if (isspace(character) != 0){
                if (PHASE_RS_NUM == column){
                    snpData->rsNumber[index] = '\0';
                }
                else if (PHASE_POS == column){
                    tmp[index] = '\0';
                    snpData->pos = atol(tmp);
                }
                column++;
                index = 0;
            }
            /* rs# */
            else if (PHASE_RS_NUM == column){
                if (isalnum(character) != 0){
                    snpData->rsNumber[index] = character;
                    index++;
                }
            }
            /* pos */
            else if (PHASE_POS == column){
                tmp[index] = character;
                index++;
            }
            /* 3ܰʹߤΥǡ򻲾Ȥ */
            else if (column >= PHASE_DATA){
                /* NȰפǡ򥫥 */
                if ('N' == character){
                    snpData->missingDataCount++;
                } 
                else{
                    for (i = 0; i < refNum; i++){
                        /* SNPallelesȰפǡ򥫥 */
                        if (snpData->SNPalleles[i] == character){
                            snpData->SNPallelesCount[i]++;
                            flag = 1;
                        }
                    } 
                    /* ե饰äƤʤ硢ܡʣܡˤNPalleles */
                    if (flag == 0){
                        /* SNPalleles */
                        snpData->SNPalleles[refNum] = character;
                        /* SNPallelesȰפǡ򥫥 */
                        snpData->SNPallelesCount[refNum]++;
                        refNum++;
                    }
                    /* ե饰Υꥢ */
                    flag = 0;
                }
                /* ҥǡǼ */
                snpData->SNPdata[dataIndex] = character;
                dataIndex++;
            }
        }
    }
    return retval;
}

/*********************************************/
/* ¤SnpData˥ץǡ򥳥ԡ */
/*********************************************/
int DataReaderDataCopyToSnpData(SnpData *snpData, char *sampleData, long dataNum, long sampleNum)
{
    long i = 0;

    for (i = 0; i < dataNum; i++){
        /* ץǡΥɥ쥹 */
        snpData[i].SNPdata = &sampleData[i * sampleNum];
    }

    return 0;
}

/*****************************************/
/* ¤SnpDataΥݤ */
/*****************************************/
int DataReaderSnpDataMemoryAllocate(SnpData *snpData, long dataNum, long sampleNum)
{
    long i = 0;

    /* ե뤫ɤ߹ */
    for (i = 0; i < dataNum; i++){
        /* SNPǡǼΥ */
        snpData[i].SNPdata = (char*)malloc1Dim(sizeof(char), sampleNum);
    }

    return 0;
}

/*****************************************/
/* ¤SnpDataФΥ */
/*****************************************/
int DataReaderSnpDataMemoryFree(SnpData *snpData, long dataNum)
{
    long i = 0;

    if (NULL != snpData){
        for (i = 0; i < dataNum; i++){
            /* SNPǡǼΥ곫 */
            free1Dim(snpData[i].SNPdata);
        }
        free1Dim(snpData);
    }

    return 0;
}

/*****************************************/
/* haplotype֥åΰ˳Ǽ */
/*****************************************/
int DataReaderSetHaplotypeBlockArea(FILE *fp, long *blockArea)
{
    long index = 0;
    long strIndex = 0;
    long valIndex = 0;
    char string[MAX_LEN];
    char value[MAX_LEN];

    /* Ԥɤ߹ */
    while ( (fgets(string, MAX_LEN, fp)) != NULL){
        strIndex = 0;
        valIndex = 0;
        while (string[strIndex] != '\n'){
            value[valIndex] = string[strIndex];
            strIndex++;
            valIndex++;
        }
        value[valIndex] = '\0';
        blockArea[index] = atol(value);
        index++;
    }
    return 0;
}

/********************************************/
/* ٤Ƥι¤Υǡե˽Ϥ */
/********************************************/
//void DataReaderOutputAllData(FILE *fp, SnpData *snpData, long line)
//{
//    long i = 0;
//
//    for (i = 0; i < line; i++){
//        DataReaderOutputData(fp, &snpData[i]);
//
//    }
//}

/************************************/
/* ¤Υǡե˽Ϥ */
/************************************/
//void DataReaderOutputData(FILE *fp, SnpData *snpData)
//{
//    int j = 0;
//
//    fprintf(fp, "%10s, %10ld, ", snpData->rsNumber, snpData->pos);
//    for (j = 0; j < snpData->allelesNum; j++){
//        fprintf(fp, "%c=>%3d, ", snpData->SNPalleles[j], snpData->SNPallelesCount[j]);
//    }
//    fprintf(fp, "N=>%3d, DataNum=>%3d, ", snpData->missingDataCount, snpData->dataNum);
//    /* ƿͤİҤΥǡݻʤ */
//    //for (j = 0; j < snpData->dataNum*2; j++){
//    //    fprintf(fp, "%c", snpData->SNPdata[j]);
//    //}
//    fprintf(fp, "\n");
//}

/******************************/
/* ϥǡ¤Τ˼ */
/******************************/
//int DataReaderSetInputData(char *filename, InputData *inputData)
//{
//    int retval = 0;
//    FILE *fp = NULL;
//    char tmp[MAX_LEN];
//
//    /* ե륪ץ */
//    retval = InputFileOpen(&fp, filename);
//    if (retval != 0){
//        return -1;
//    }
//
//    retval = DataReaderGetValue(fp, "InputFile1", tmp);
//    if(retval == 0){
//        strcpy(inputData->inputFile1, tmp);
//    }
//    retval = DataReaderGetValue(fp, "InputFile2", tmp);
//    if(retval == 0){
//        strcpy(inputData->inputFile2, tmp);
//    }
//    retval = DataReaderGetValue(fp, "OutputFile1", tmp);
//    if(retval == 0){
//        strcpy(inputData->outputFile1, tmp);
//    }
//    retval = DataReaderGetValue(fp, "OutputLevel", tmp);
//    if(retval == 0){
//        inputData->outputLevel = atoi(tmp);
//    }
//    retval = DataReaderGetValue(fp, "Score", tmp);
//    if(retval == 0){
//        inputData->score = atoi(tmp);
//    }
//    retval = DataReaderGetValue(fp, "Repeat", tmp);
//    if(retval == 0){
//        inputData->repeat = atol(tmp);
//    }
//    retval = DataReaderGetValue(fp, "Analysis", tmp);
//    if(retval == 0){
//        inputData->analysis = atoi(tmp);
//    }
//
//    /* ե륯 */
//    FileClose(fp);
//
//    return retval;
//}

/******************************************************/
/* ե뤫ꤷб֤ͤ */
/******************************************************/
//int DataReaderGetValue(FILE *fp, char *key, char *value)
//{
//    int len = 0;
//    int strIndex = 0;
//    int valIndex = 0;
//    int retval = -1;
//    char string[MAX_LEN];
//
//    len = strlen(key);
//
//    /* եݥ󥿤Ƭ᤹ */
//    fseek(fp, 0L, SEEK_SET);
//
//    /* Ԥɤ߹ */
//    while ( (fgets(string, MAX_LEN, fp)) != NULL){
//        /* ꤷĤä硢ͤ */
//        if (strncmp(key, string, len) == 0){
//            strIndex = len + 1;
//            while (string[strIndex] != '\n'){
//                value[valIndex] = string[strIndex];
//                strIndex++;
//                valIndex++;
//            }
//            value[valIndex] = '\0';
//            retval = 0;
//        }
//    }
//    return retval;
//}

/************************************/
/* Ĥϥǡɽ */
/************************************/
int DataReaderMakeTable(SnpData *snpData1, SnpData *snpData2, int **T)
{
    /* SNPallelesĤξ */
    if ( (2 == snpData1->allelesNum) && (2 == snpData2->allelesNum) ){
        /* ɽκ */
        T[0][0] = snpData1->SNPallelesCount[0];
        T[0][1] = snpData1->SNPallelesCount[1];
        T[1][0] = snpData2->SNPallelesCount[0];
        T[1][1] = snpData2->SNPallelesCount[1];
    }
    /* SNPallelesĤξ */
    else if ( (3 == snpData1->allelesNum) && (3 == snpData2->allelesNum) ){
        /* ɽκ */
        T[0][0] = snpData1->SNPallelesCount[0];
        T[0][1] = snpData1->SNPallelesCount[1] + snpData1->SNPallelesCount[2];
        T[1][0] = snpData2->SNPallelesCount[0];
        T[1][1] = snpData2->SNPallelesCount[1] + snpData2->SNPallelesCount[2];
    }
    return 0;
}

/***********************************/
/* ĤSNPalleleνؤ */
/***********************************/
int DataReaderShiftSNPalleles(SnpData *snpData, int allele1, int allele2)
{
    int tmpCount = 0;
    char tmpSNP = 0;

    /* Υǡ */
    tmpSNP = snpData->SNPalleles[allele1];
    tmpCount = snpData->SNPallelesCount[allele1];
    /* ؤ */
    snpData->SNPalleles[allele1] = snpData->SNPalleles[allele2];
    snpData->SNPalleles[allele2] = tmpSNP;
    snpData->SNPallelesCount[allele1] = snpData->SNPallelesCount[allele2];
    snpData->SNPallelesCount[allele2] = tmpCount;

    return 0;
}

/********************************************/
/* ĤΥǡSNPallelesν֤å */
/********************************************/
int DataReaderCheckSNPalleles(SnpData *snpData1, SnpData *snpData2)
{
    int i = 0;
    int j = 0;
    int index = 0;
    int count = 0;

    /* SNPallelesĤξ */
    if ( (2 == snpData1->allelesNum) && (2 == snpData2->allelesNum) ){
        /* ĤΥǡSNPallelesν֤Ʊ硢⤷ʤ */
        if ( (snpData1->SNPalleles[0] == snpData2->SNPalleles[0]) && (snpData1->SNPalleles[1] == snpData2->SNPalleles[1]) ){
            return 0;
        }
        /* ĤΥǡSNPallelesν֤žƤ硢֤ؤ */
        else if ( (snpData1->SNPalleles[0] == snpData2->SNPalleles[1]) && (snpData1->SNPalleles[1] == snpData2->SNPalleles[0]) ){
            /* ĤSNPalleleνؤ */
            DataReaderShiftSNPalleles(snpData2, 0, 1);
            return 0;
        }
        /* ĤΥǡSNPallelesۤʤäƤ */
        else{
            return -1;
        }
    }
    /* SNPallelesĤξ */
    else if ( (3 == snpData1->allelesNum) && (3 == snpData2->allelesNum) ){
        /* ĤΥǡgenotyoeȤSNPꤹ */
        for (i = 1; i < 3; i++){
            if(snpData1->SNPallelesCount[i] > snpData1->SNPallelesCount[index]){
                index = i;
            }
        }
        if (index != 0){
            /* genotyoeȤSNPǡƬˤ */
            /* ĤSNPalleleνؤ */
            DataReaderShiftSNPalleles(snpData1, 0, index);
        }
        /* snpData1snpData2SNPǡ¤Ӥ򤽤 */
        for (i = 0; i < 3; i++){
            for (j = 0; j < 3; j++){
                if (snpData1->SNPalleles[i] == snpData2->SNPalleles[j]){
                    count++;
                    if (i == j){
                        break;
                    }
                    else{
                        /* snpData2SNPǡ¤ӽѹ */
                        /* ĤSNPalleleνؤ */
                        DataReaderShiftSNPalleles(snpData2, i, j);
                        break;
                    }
                }
            }
        }
        /* ĤΥǡƱSNPallelesǤʤä */
        if (count != 3){
            return -1;
        }
        return 0;
    }
    /* caseSNPallelesġcontrolSNPallelesĤξ */
    /* PhasingHapmapcaseΥǡA/T¸ߤcontrolΥǡA¸ߤʤ褦ʾ */
    else if ( (2 == snpData1->allelesNum) && (1 == snpData2->allelesNum) ){
        /* ܤSNPalleleƱ */
        if (snpData1->SNPalleles[0] == snpData2->SNPalleles[0]){
            /* controlˣܤSNPallele򥳥ԡ */
            snpData2->SNPalleles[1] = snpData1->SNPalleles[1];
            snpData2->allelesNum++;
            return 0;
        }
        /* ܤSNPallele㤦 */
        else if (snpData1->SNPalleles[1] == snpData2->SNPalleles[0]){
            /* controlˣܤSNPallele򥳥ԡ */
            snpData2->SNPalleles[0] = snpData1->SNPalleles[1];
            snpData2->allelesNum++;
            /* ĤSNPalleleνؤ */
            DataReaderShiftSNPalleles(snpData2, 0, 1);
            return 0;
        }
    }
    /* caseSNPallelesġcontrolSNPallelesĤξ */
    /* PhasingHapmapcaseΥǡA¸ߤcontrolΥǡA/T¸ߤ褦ʾ */
    else if ( (1 == snpData1->allelesNum) && (2 == snpData2->allelesNum) ){
        /* ܤSNPalleleƱ */
        if (snpData1->SNPalleles[0] == snpData2->SNPalleles[0]){
            /* controlˣܤSNPallele򥳥ԡ */
            snpData1->SNPalleles[1] = snpData2->SNPalleles[1];
            snpData1->allelesNum++;
            return 0;
        }
        /* ܤSNPallele㤦 */
        else if (snpData1->SNPalleles[0] == snpData2->SNPalleles[1]){
            /* caseˣܤSNPallele򥳥ԡ */
            snpData1->SNPalleles[1] = snpData2->SNPalleles[0];
            snpData1->allelesNum++;
            /* ĤSNPalleleνؤ */
            DataReaderShiftSNPalleles(snpData2, 0, 1);
            return 0;
        }
    }
    /* caseSNPallelesġcontrolSNPallelesĤξ */
    /* PhasingHapmapcasecontrolΥǡA¸ߤʤ褦ʾ */
    else if ( (1 == snpData1->allelesNum) && (1 == snpData2->allelesNum) ){
        /* ܤSNPalleleƱ */
        if (snpData1->SNPalleles[0] == snpData2->SNPalleles[0]){
            /* ܤSNPallele */
            snpData1->SNPalleles[1] = '-';
            snpData2->SNPalleles[1] = '-';
            snpData1->allelesNum++;
            snpData2->allelesNum++;
            return 0;
        }
        /* ܤSNPallele㤦 */
        else{
            /* caseˣܤSNPallele򥳥ԡ */
            snpData1->SNPalleles[1] = snpData2->SNPalleles[0];
            snpData1->allelesNum++;
            /* controlˣܤSNPallele򥳥ԡ */
            snpData2->SNPalleles[1] = snpData1->SNPalleles[0];
            snpData2->allelesNum++;
            /* ĤSNPalleleνؤ */
            DataReaderShiftSNPalleles(snpData2, 0, 1);
            return 0;
        }
    }
    else{
        return -1;
    }
    return 0;
}

/******************************************************************/    
/* ϥǡåѤϥǡ */
/******************************************************************/
long DataReaderMakeParallelData(SnpData *snpTmpData1, SnpData *snpTmpData2, long line1, long line2, SnpData **snpData1, SnpData **snpData2, char **caseData, char **controlData)
{
    int retval = 0;
    long a = 0;
    long b = 0;
    long index = 0;
    long dataCount = 0;
    long caseIndex = 1;
    long controlIndex = 1;

    a = snpTmpData1[1].dataNum;
    b = snpTmpData2[1].dataNum;

    while ( caseIndex < line1 || controlIndex < line2 ){
        /* ǡposӤƱսΰҤǤ뤳Ȥǧ */
        if (snpTmpData1[caseIndex].pos == snpTmpData2[controlIndex].pos){
            /* ĤΥǡSNPallelesν֤å */
            retval = DataReaderCheckSNPalleles(&snpTmpData1[caseIndex], &snpTmpData2[controlIndex]);
            if(0 == retval){
                /* Data򥫥 */
                dataCount++;
            }
            /* snpTmpData1(case)μΥǡ򻲾Ȥ */
            caseIndex++;
            /* snpTmpData2μΥǡ򻲾Ȥ */
            controlIndex++;
        }
        else if (snpTmpData1[caseIndex].pos < snpTmpData2[controlIndex].pos){
            /* snpData1(case)μΥǡ򻲾Ȥ */
            caseIndex++;
        }
        else if (snpTmpData1[caseIndex].pos > snpTmpData2[controlIndex].pos){
            /* snpData2(control)μΥǡ򻲾Ȥ */
            controlIndex++;
        }
    }

    /* ǡǼѹ¤ΤΥ */
    *snpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), dataCount);
    *snpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), dataCount);
    /* ץǡǼcharΥ */
    *caseData = (char*)malloc1Dim(sizeof(char), dataCount * a);
    *controlData = (char*)malloc1Dim(sizeof(char), dataCount * b);

    caseIndex = 1;
    controlIndex = 1;
    while ( caseIndex < line1 || controlIndex < line2 ){
        /* ǡposӤƱսΰҤǤ뤳Ȥǧ */
        if (snpTmpData1[caseIndex].pos == snpTmpData2[controlIndex].pos){
            /* ĤΥǡSNPallelesν֤å */
            retval = DataReaderCheckSNPalleles(&snpTmpData1[caseIndex], &snpTmpData2[controlIndex]);
            if(0 == retval){
                /* 󲽥ǡκ */
                //(*snpData1)[index] = snpTmpData1[caseIndex];
                strcpy( (*snpData1)[index].rsNumber, snpTmpData1[caseIndex].rsNumber );
                strcpy( (*snpData1)[index].SNPalleles, snpTmpData1[caseIndex].SNPalleles );
                strcpy( (*snpData1)[index].chrom, snpTmpData1[caseIndex].chrom );
                (*snpData1)[index].pos = snpTmpData1[caseIndex].pos;
                strncpy( &(*caseData)[index * a], snpTmpData1[caseIndex].SNPdata, a );
                (*snpData1)[index].allelesNum = snpTmpData1[caseIndex].allelesNum;
                (*snpData1)[index].dataNum = snpTmpData1[caseIndex].dataNum;
                (*snpData1)[index].SNPallelesCount[0] = snpTmpData1[caseIndex].SNPallelesCount[0];
                (*snpData1)[index].SNPallelesCount[1] = snpTmpData1[caseIndex].SNPallelesCount[1];
                (*snpData1)[index].SNPallelesCount[2] = snpTmpData1[caseIndex].SNPallelesCount[2];
                (*snpData1)[index].missingDataCount = snpTmpData1[caseIndex].missingDataCount;
                //(*snpData2)[index] = snpTmpData2[controlIndex];
                strcpy( (*snpData2)[index].rsNumber, snpTmpData2[controlIndex].rsNumber );
                strcpy( (*snpData2)[index].SNPalleles, snpTmpData2[controlIndex].SNPalleles );
                strcpy( (*snpData2)[index].chrom, snpTmpData2[controlIndex].chrom );
                (*snpData2)[index].pos = snpTmpData2[controlIndex].pos;
                strncpy( &(*controlData)[index * b], snpTmpData2[controlIndex].SNPdata, b );
                (*snpData2)[index].allelesNum = snpTmpData2[controlIndex].allelesNum;
                (*snpData2)[index].dataNum = snpTmpData2[controlIndex].dataNum;
                (*snpData2)[index].SNPallelesCount[0] = snpTmpData2[controlIndex].SNPallelesCount[0];
                (*snpData2)[index].SNPallelesCount[1] = snpTmpData2[controlIndex].SNPallelesCount[1];
                (*snpData2)[index].SNPallelesCount[2] = snpTmpData2[controlIndex].SNPallelesCount[2];
                (*snpData2)[index].missingDataCount = snpTmpData2[controlIndex].missingDataCount;

                index++;
            }
            /* snpTmpData1(case)μΥǡ򻲾Ȥ */
            caseIndex++;
            /* snpTmpData2μΥǡ򻲾Ȥ */
            controlIndex++;
        }
        else if (snpTmpData1[caseIndex].pos < snpTmpData2[controlIndex].pos){
            /* snpData1(case)μΥǡ򻲾Ȥ */
            caseIndex++;
        }
        else if (snpTmpData1[caseIndex].pos > snpTmpData2[controlIndex].pos){
            /* snpData2(control)μΥǡ򻲾Ȥ */
            controlIndex++;
        }
    }
    
    return dataCount;
}


/******************************************/
/* ϥեξե˽Ϥ */
/******************************************/
//void DataReaderOutputHeader(FILE *fp, InputData *inputData)
//{
//    fprintf(fp, "case Data    => %s\n", inputData->inputFile1);
//    fprintf(fp, "control Data => %s\n\n", inputData->inputFile2);
//    if (0 == iWay){
//        fprintf(fp, "׻PearsonScore\n");
//    }
//    else{
//        fprintf(fp, "׻Fst\n");
//    }
//
//    switch(inputData->outputLevel){
//        case 0:
//            /* ̥եϡlevel0 */
//            break;
//        case 1:
//            /* ̥եϡlevel1 إå*/
//            fprintf(fp, "\nrs# chrom pos alleles p score a1 a2 b1 b2\n");
//            break;
//        default:
//            /* ̥եϡlevel0 */
//            break;
//    }
//}

/********************************/
/* ̤ե˽Ϥ */
/********************************/
//void DataReaderOutputAllResult(int level, FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, InputData *inputData, long dataNum)
//{
//    long i = 0;
//
//    /* ϥեե */
//    DataReaderOutputHeader(fp, inputData);
//
//    for (i = 0; i < dataNum; i++){
//        DataReaderOutputResult(level, fp, &snpData1[i], &snpData2[i], &outputData[i], inputData->repeat);
//
//    }
//}

/********************************************/
/* ʬθ̤ե˽Ϥ */
/********************************************/
//void DataReaderOutputResult(int level, FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, long repeat)
//{
//    switch(level){
//        case 0:
//            /* ̥եϡlevel0 */
//            DataReaderOutputResultLevel0(fp, snpData1, snpData2, outputData, repeat);
//            break;
//        case 1:
//            /* ̥եϡlevel1 */
//            DataReaderOutputResultLevel1(fp, snpData1, snpData2, outputData);
//            break;
//        default:
//            /* ̥եϡlevel0 */
//            DataReaderOutputResultLevel0(fp, snpData1, snpData2, outputData, repeat);
//            break;
//    }
//}

/**********************************/
/* ̥եϡlevel0 */
/**********************************/
//void DataReaderOutputResultLevel0(FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, long repeat)
//{
//    int a1 = 0;
//    int a2 = 0;
//    int b1 = 0;
//    int b2 = 0;
//
//    /* ե */
//    fprintf(fp, "\n");
//    fprintf(fp, "*** SnpData Infomation ***\n");
//    fprintf(fp, "rs# => %10s : chrom => %5s : pos => %10ld : ", snpData1->rsNumber, snpData1->chrom, snpData1->pos);
//    if (2 == snpData1->allelesNum){
//        fprintf(fp, "SNPalleles => %c/%c \n", snpData1->SNPalleles[0], snpData1->SNPalleles[1]);
//        a1 = snpData1->SNPallelesCount[0];
//        a2 = snpData1->SNPallelesCount[1];
//        b1 = snpData2->SNPallelesCount[0];
//        b2 = snpData2->SNPallelesCount[1];
//    }
//    else if (3 == snpData1->allelesNum){
//        fprintf(fp, "SNPalleles => %c/%c%c \n", snpData1->SNPalleles[0], snpData1->SNPalleles[1], snpData1->SNPalleles[2]);
//        a1 = snpData1->SNPallelesCount[0];
//        a2 = snpData1->SNPallelesCount[1] + snpData1->SNPallelesCount[2];
//        b1 = snpData2->SNPallelesCount[0];
//        b2 = snpData2->SNPallelesCount[1] + snpData2->SNPallelesCount[2];
//    }
//    fprintf(fp, "  ** Observer **\n");
//    fprintf(fp, "    Table   | genotype1 | genotype2 |  sum  || NNǡ | ץͿ\n");
//    fprintf(fp, "    case    | %9d | %9d | %4d  || %10d | %12d\n", a1, a2, a1+a2, snpData1->missingDataCount, snpData1->dataNum);
//    fprintf(fp, "    control | %9d | %9d | %4d  || %10d | %12d\n", b1, b2, b1+b2, snpData2->missingDataCount, snpData2->dataNum);
//    fprintf(fp, "    sum     | %9d | %9d | %4d\n", a1+b1, a2+b2, a1+a2+b1+b2);
//    fprintf(fp, "    Sobs => %.10lf\n", outputData->Sobs);
//    fprintf(fp, "    Pr => %.10e\n", exp(outputData->Pr));
//    fprintf(fp, "  ** Permutationʥؿ **\n");
//    fprintf(fp, "    count(S>=Sobs) => %d : repeat(roop) => %ld\n", outputData->count, repeat);
//    fprintf(fp, "    count / repeat => %.10lf\n", (double)outputData->count/repeat);
//    fprintf(fp, "  ** ˡ p = Hj/F **\n");
//    //fprintf(fp, "    Hj => %.10e\n", outputData->Hj);
//    //fprintf(fp, "    F  => %.10e\n", outputData->F);
//    fprintf(fp, "    p  => %.10e\n", outputData->p);
//}

/**********************************/
/* ̥եϡlevel1 */
/**********************************/
//void DataReaderOutputResultLevel1(FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData)
//{
//    int a1 = 0;
//    int a2 = 0;
//    int b1 = 0;
//    int b2 = 0;
//
//    /* ե */
//    //fprintf(fp, "\nrs# chrom pos alleles p score a1 a2 b1 b2\n");
//    fprintf(fp, "%s %s %ld ", snpData1->rsNumber, snpData1->chrom, snpData1->pos);
//    if (2 == snpData1->allelesNum){
//        fprintf(fp, "%c/%c ", snpData1->SNPalleles[0], snpData1->SNPalleles[1]);
//        a1 = snpData1->SNPallelesCount[0];
//        a2 = snpData1->SNPallelesCount[1];
//        b1 = snpData2->SNPallelesCount[0];
//        b2 = snpData2->SNPallelesCount[1];
//    }
//    else if (3 == snpData1->allelesNum){
//        fprintf(fp, "%c/%c%c ", snpData1->SNPalleles[0], snpData1->SNPalleles[1], snpData1->SNPalleles[2]);
//        a1 = snpData1->SNPallelesCount[0];
//        a2 = snpData1->SNPallelesCount[1] + snpData1->SNPallelesCount[2];
//        b1 = snpData2->SNPallelesCount[0];
//        b2 = snpData2->SNPallelesCount[1] + snpData2->SNPallelesCount[2];
//    }
//    fprintf(fp, "%.10e %.10lf %d %d %d %d\n", outputData->p, outputData->Sobs, a1, a2, b1, b2);
//}

/**************************************/
/* ϥǡΥץ */
/**************************************/
long DataReaderGetSampleNum(FILE *fp, int dataType)
{
    long retval = 0;

    switch(dataType){
        case 0:
            /* ϥǡHapmap */
            retval = DataReaderGetHapmapSampleNum(fp);
            break;
        case 1:
            /* ϥǡHaplotypeData */
            retval = DataReaderGetHaplotypeSampleNum(fp);
            break;
        case 2:
            /* ϥǡPhasingHapmap */
            retval = DataReaderGetPhasingHapmapSampleNum(fp);
            break;
        default:
            break;
    }

    return retval;
}

/*****************************************/
/* HapmapDataΥץ */
/*****************************************/
long DataReaderGetHapmapSampleNum(FILE *fp)
{
    int character = 0;
    long column = 1;     /* Haplotypeǡ */
    long dataNum = 0;    /* ץͿ */

    /* ʸɤ߹ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* ɤ߹֤ͤƽλ */
        if ('\n' == character){
            return dataNum * 2;
        }
        /* ե򥫥 */
        else if (isspace(character) != 0){
            column++;
            /* 12ܹܰԤΥǡ򥫥 */
            if (column >= HAPMAP_DATA){
                dataNum++;
            }
        }
    }

    /* HapmapDataϰ͡ʣˤǣĤΰҥǡäƤΤǣܤ */
    return dataNum * 2;
}

/***************************************/
/* HaplotypeDataΥץ */
/***************************************/
long DataReaderGetHaplotypeSampleNum(FILE *fp)
{
    int character = 0;
    long column = 1;     /* Haplotypeǡ */
    long dataNum = 0;    /* ץ */

    /* ʸɤ߹ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* ɤ߹֤ͤƽλ */
        if ('\n' == character){
            return dataNum;
        }
        /* ե򥫥 */
        else if (isspace(character) != 0){
            column++;
            /* 7ܹܰԤΥǡ򥫥 */
            if (column >= HAPLOTYPE_DATA){
                dataNum++;
            }
        }
    }
    return dataNum;
}

/***************************************************/
/* phasing줿HapmapǡΥץ */
/***************************************************/
long DataReaderGetPhasingHapmapSampleNum(FILE *fp)
{
    int character = 0;
    long column = 1;     /* phasing줿Hapmapǡ */
    long dataNum = 0;    /* ץ */

    /* ʸɤ߹ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* ɤ߹֤ͤƽλ */
        if ('\n' == character){
            return dataNum;
        }
        /* ե򥫥 */
        else if (isspace(character) != 0){
            column++;
            /* 3ܹܰԤΥǡ򥫥 */
            if (column >= PHASE_DATA){
                dataNum++;
            }
        }
    }
    return dataNum;
}

/***********************************************/
/* HaplotypeDataԤΰҥǡ˳Ǽ */
/***********************************************/
int DataReaderSetHaplotypeSequence(FILE *fp, char **sequence, int index)
{
    int retval = -1;    /* եǸޤƤ-1֤ */
    int character = 0;
    int column = 1;     /* Haplotypeǡ */
    int dataIndex = 0;

    /* ¤Τν */

    /* ʸɤ߹ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* ɤ߹ͤݻƽλ */
        if ('\n' == character){
            retval = 0;
            break;
        }
        /* ե򥫥 */
        else if (isspace(character) != 0){
            column++;
        }
        /* 12ܹܰԤΥǡ򻲾Ȥ */
        else if (column >= HAPLOTYPE_DATA){
            /* ҥǡǼ */
            sequence[dataIndex][index] = character;
            dataIndex++;
        }
    }
    return retval;
}

/***************************/
/* Haplotype٤׻ */
/***************************/
int DataReaderCalcHaplotypeFrequency(char **sequence, long dataNum, int L, double **frequency)
{
    int i = 0;
    int total = 0;
	int patern = 0;
	int flag = 0;
	int index = 0;
	int nextIndex = 0;
    int retval = -1;

    int *reference = NULL;
	int *count = NULL;

    /*  */
	reference = (int*)malloc1Dim(sizeof(int), dataNum);
    if (NULL == reference) { goto finalize; }
	count = (int*)malloc1Dim(sizeof(int), dataNum);
    if (NULL == count) { goto finalize; }

    while(total < dataNum){
        count[patern] = 0;
		flag = 0;
		nextIndex = 0;

		for(i = index; i < dataNum; i++){
            /* Ǥ˸Ф줿ѥťɻ */
			if(reference[i] == 0){
                /* ȥѥƱѥǤХȤ */
				if(strncmp(sequence[index], sequence[i], L)==0){
					reference[i] = 1;
					count[patern]++;
					total++;
				}
				else{
                    /* λȥѥ򵭲 */
					if(nextIndex == 0){
						nextIndex = i;
					}
				}
			}
		}
		patern++;
		index = nextIndex;
	}

    /* ٳǼѥ */
	*frequency = (double*)malloc1Dim(sizeof(double), patern);
    if (NULL == *frequency) { goto finalize; }
    /* ٤׻ */
    for (i = 0; i < patern; i++){
        (*frequency)[i] = (double)count[i] / total;
    }
    retval = patern;

finalize:;
    /* ݤ */
    free1Dim(reference);
    free1Dim(count);

    return retval;
}

/************************/
/* populationType׻ */
/************************/
int DataReaderPopulationType(SnpData *snpData1, SnpData *snpData2, int *populationType)
{
    long a = 0;
    long b = 0;
    long n = 0;
    long h = 0;

    a = snpData1->dataNum;
    b = snpData2->dataNum;
    n = a+b;

    for (h = 0; h < a; h++){
        populationType[h] = 0;
    }
    for (h = a; h < n; h++){
        populationType[h] = 1;
    }

    return 0;
}

/****************************************/
/* ĤϥǡDiɽ */
/****************************************/
int DataReaderMakeTableDi(SnpData *snpData1, SnpData *snpData2, int *d, int **T)
{
    int i = 0;
    int j = 0;
    long h = 0;
    long a = 0;
    long b = 0;
    long n = 0;
    long len = 0;
    char reference = 0;

    int *data = NULL;
    int *data1 = NULL;
    int *data2 = NULL;

    a = snpData1->dataNum;
    b = snpData2->dataNum;
    n = a + b;
   
    /* dataΥ */
    data = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == data) { goto finalize; }
    /* data1Υ */
    data1 = (int*)malloc1Dim(sizeof(int), a);
    if (NULL == data1) { goto finalize; }
    /* data2Υ */
    data2 = (int*)malloc1Dim(sizeof(int), b);
    if (NULL == data2) { goto finalize; }

    /* ʸ */
    reference = DataReaderMaximumNuc(snpData1);

    /* genotype׻ */
    DataReaderCalcGenotype(snpData1, reference, data1);
    DataReaderCalcGenotype(snpData2, reference, data2);
    for (h = 0; h < a; h++){
        data[h] = data1[h];
    }
    for (h = 0; h < b; h++){
        data[h + a] = data2[h];
    }

    /* ɽ0ǽ */
    for (i = 0; i < ROW; i++){
        for (j = 0; j < COLUMN; j++){
            T[i][j] = 0;
        }
    }
    /* ɽ */
    for (h = 0; h < n; h++){
        T[ d[h] ][ data[h] ]++;
    }

finalize:;
    /* ݤ */
	free1Dim(data);
    free1Dim(data1);
    free1Dim(data2);

    return 0;
}

/************************************************************************/
/* ĤϥǡDiɽʸƤӽФ¦ɬץǡ */
/* 2010.11.10 ®ΤᡢƤӽФ¦ǳݤȤޤ魯      */
/************************************************************************/
int DataReaderMakeTableDiMemoryGiven(
    SnpData *snpData1,
    SnpData *snpData2,
    int *d,
    int **T,
    int *data1,
    int *data2,
    int *data)
{
    int i = 0;
    int j = 0;
    long h = 0;
    long a = 0;
    long b = 0;
    long n = 0;
    long len = 0;
    char reference = 0;

    a = snpData1->dataNum;
    b = snpData2->dataNum;
    n = a + b;
   
    /* ʸ */
    reference = DataReaderMaximumNuc(snpData1);

    /* genotype׻ */
    DataReaderCalcGenotype(snpData1, reference, data1);
    DataReaderCalcGenotype(snpData2, reference, data2);
    for (h = 0; h < a; h++){
        data[h] = data1[h];
    }
    for (h = 0; h < b; h++){
        data[h + a] = data2[h];
    }

    /* ɽ0ǽ */
    for (i = 0; i < ROW; i++){
        for (j = 0; j < COLUMN; j++){
            T[i][j] = 0;
        }
    }
    /* ɽ */
    for (h = 0; h < n; h++){
        T[ d[h] ][ data[h] ]++;
    }

    return 0;
}

/******************/
/* ʸ֤ */
/******************/
char DataReaderMaximumNuc(SnpData *snpData)
{
    int tmp = 0;
    int max = 0;
    int maxi = 0;
    int count[5] = {0, 0, 0, 0, 0};
    char nuc[5] = {'N', 'T', 'C', 'A', 'G'};
    long h = 0;
    long maxIndex = 0;

    maxIndex = snpData->dataNum;

    for (h = 0; h < maxIndex; h++){
        tmp = 0;
        switch (snpData->SNPdata[h]){
            case 'U': tmp = 1;
                    break;
            case 'u': tmp = 1;
                    break;
            case 'T': tmp = 1;
                    break;
            case 't': tmp = 1;
                    break;
            case 'C': tmp = 2;
                    break;
            case 'c': tmp = 2;
                    break;
            case 'A': tmp = 3;
                    break;
            case 'a': tmp = 3;
                    break;
            case 'G': tmp = 4;
                    break;
            case 'g': tmp = 4;
                    break;
            default:  break;
        }
        count[tmp]++;
    }

    for (tmp = 1; tmp < 5; tmp++){
        if (max < count[tmp]){
            max = count[tmp];
            maxi = tmp;
        }
    }

    return nuc[maxi];
}

/******************/
/* genotype׻ */
/******************/
int DataReaderCalcGenotype(SnpData *snpData, char reference, int *result)
{
    long h = 0;
    long maxIndex = 0;

    maxIndex = snpData->dataNum;

    for (h = 0; h < maxIndex; h++){
        if (snpData->SNPdata[h] == reference){
            result[h] = 0;
        }
        else{
            result[h] = 1;
        }
    }

    return 0;
}

/***************************/
/* Haplotype٤׻ */
/***************************/
long DataReaderHaplotypeFrequency(SnpData *snpData1, SnpData *snpData2, long jStart, long jEnd, char ***haplotype, double **freq)
{
    int retval = -1;
    long i = 0;
    long j = 0;
    long h = 0;
    long a = 0;
    long b = 0;
    long m = 0;
    long maxHaplotypeNumber = 0;
    long total = 0;
	long patern = 0;
	long index = 0;
	long nextIndex = 0;

    char **allHaplotype = NULL; /* ٤ƤhaplotypeǡǼ */
    int *referenceFlag = NULL;
	int *count = NULL;
	int *tmp = NULL;

    m = jEnd - jStart;

    /* ץͿ */
    a = snpData1[0].dataNum;
    b = snpData2[0].dataNum;
    maxHaplotypeNumber = a + b;

    /* allHaplotypeΥ */
    allHaplotype = (char**)mallocChar2Dim(maxHaplotypeNumber, m);
    if (NULL == allHaplotype) { goto finalize; }
    /*  */
	referenceFlag = (int*)malloc1Dim(sizeof(int), maxHaplotypeNumber);
    if (NULL == referenceFlag) { goto finalize; }
	count = (int*)malloc1Dim(sizeof(int), maxHaplotypeNumber);
    if (NULL == count) { goto finalize; }
	tmp = (int*)malloc1Dim(sizeof(int), maxHaplotypeNumber);
    if (NULL == tmp) { goto finalize; }

    /* ٤ƤhaplotypeǡǼ */
    for (j = jStart; j < jEnd; j++){
        for (h = 0; h < a; h++){
            allHaplotype[h][index] = snpData1[j].SNPdata[h];
        }
        for (h = 0; h < b; h++){
            allHaplotype[h + a][index] = snpData2[j].SNPdata[h];
        }
        index++;
    }

    index = 0;
    while(total < maxHaplotypeNumber){
        count[patern] = 0;
		nextIndex = 0;
        tmp[patern] = index;

		for(i = index; i < maxHaplotypeNumber; i++){
            /* Ǥ˸Ф줿ѥťɻ */
			if(referenceFlag[i] == 0){
                /* ȥѥƱѥǤХȤ */
				if(strncmp(allHaplotype[index], allHaplotype[i], m)==0){
					referenceFlag[i] = 1;
					count[patern]++;
					total++;
				}
				else{
                    /* λȥѥ򵭲 */
					if(nextIndex == 0){
						nextIndex = i;
					}
				}
			}
		}
		patern++;
		index = nextIndex;
	}

    /* haplotypeǼѥ */
    *haplotype = (char**)mallocChar2Dim(patern, m);
    if (NULL == haplotype) { goto finalize; }
    /* ٳǼѥ */
	*freq = (double*)malloc1Dim(sizeof(double), patern);
    if (NULL == freq) { goto finalize; }

    for (i = 0; i < patern; i++){
        /* иhaplotypeѥǼ */
        strncpy((*haplotype)[i], allHaplotype[ tmp[i] ], m);
        /* ٤׻ */
        (*freq)[i] = (double)count[i] / total;
    }
    retval = patern;

finalize:;
    /* ݤ */
    freeChar2Dim(allHaplotype, maxHaplotypeNumber);
    free1Dim(referenceFlag);
    free1Dim(count);
    free1Dim(tmp);

    return retval;
}

/*****************************/
/* SnpData򥷡󥹤Ѵ */
/*****************************/
int DataReaderSequences(SnpData *snpData, long jStart, long jEnd, char **sequence)
{
    long j = 0;
    long h = 0;
    long m = 0;
	long index = 0;
    long dataNum = 0;

    /* ץ */
    dataNum = snpData[0].dataNum;

    /* ٤ƤhaplotypeǡǼ */
    for (j = jStart; j < jEnd; j++){
        for (h = 0; h < dataNum; h++){
            sequence[h][index] = snpData[j].SNPdata[h];
        }
        index++;
    }

    return 0;
}

/**************************************/
/* DNAǡSnpDataѴ */
/**************************************/
int DataReaderSequenceToSnpData(char **sequences, SnpData *snpData, long dataNum, long size)
{
    /* dataNumSNP */
    /* sizeץͿa or b */
    long j = 0;
    long h = 0;

    /* ĤȲѴ */
    for (j = 0; j < dataNum; j++){
        snpData[j].dataNum = size;
        snpData[j].pos = j;
        for (h = 0; h < size; h++){
            snpData[j].SNPdata[h] = sequences[h][j];
        }
    }

    return 0;
}
