/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_DATA_READER__
#define __HEADER_FILE_DATA_READER__

#include "snp_Config.h"
#include "snp_Table.h"

/* ϥǡǼѹ¤ */
typedef struct struct_SNPData { 
	char rsNumber[RS_NUM_LEN];      /* rs# */ 
	char SNPalleles[SNP_NUM];       /* SNPalleles */
    char chrom[CHROM_LEN];          /* chrom */
    long pos;                       /* pos */
	//char SNPdata[SNP_DATA_LEN];     /* SNPǡǼ */
    char *SNPdata;                  /* SNPǡǼ */
    int allelesNum;                 /* SNPallelesΥѥ */
    int dataNum;                    /* ǡΥץ */
    int SNPallelesCount[SNP_COUNT]; /* SNPallelesȹפǡ */
    int missingDataCount;           /* MissingData(N)Υǡ */
    /* add 2010.11.10 ®Τʲɲ */
    int flag;                       /* ѥե饰 */
    char maximumNuc;                /* majorʱ */
} SnpData;

/* ϥǡǼѹ¤ */
typedef struct struct_OutputData { 
    double Sobs;
    double Pr;
    double Hj;
    double F;
    double p;
    int count;
} OutputData;

/* ץȥ */
/* ϥե򳫤 */
int InputFileOpen(FILE **fp, char *file);
/* ϥե򳫤 */
int OutputFileOpen(FILE **fp, char *file);
/* եĤ */
void FileClose(FILE *fp);

/* եιԿ򥫥Ȥ */
long DataReaderCountFileLine(FILE *fp);
/* ϥǡ¤Τ˼ */
int DataReaderSetAllData(FILE *fp, SnpData *snpData, long line, int dataType);
/* ϥǡԤ¤Τ˼ */
int DataReaderSetData(FILE *fp, SnpData *snpData, long line, int dataType);
/* Hapmapǡ¤Τ˼ */
int DataReaderSetAllHapmapData(FILE *fp, SnpData *snpData, long line);
/* HapmapǡԤ¤Τ˼ */
int DataReaderSetHapmapData(FILE *fp, SnpData *snpData, long line);
/* HaplotypeData¤Τ˼ */
int DataReaderSetAllHaplotypeData(FILE *fp, SnpData *snpData, long line);
/* HaplotypeDataԤ¤Τ˼ */
int DataReaderSetHaplotypeData(FILE *fp, SnpData *snpData, long line);
/* phasing줿Hapmapǡ¤Τ˼ */
int DataReaderSetAllPhasingHapmapData(FILE *fp, SnpData *snpData, long line);
/* phasing줿HapmapǡԤ¤Τ˼ */
int DataReaderSetPhasingHapmapData(FILE *fp, SnpData *snpData, long line);
/* ¤SnpData˥ץǡ򥳥ԡ */
int DataReaderDataCopyToSnpData(SnpData *snpData, char *sampleData, long dataNum, long sampleNum);
/* ¤SnpDataФΥݤ */
int DataReaderSnpDataMemoryAllocate(SnpData *snpData, long dataNum, long sampleNum);
/* ¤SnpDataФΥ */
int DataReaderSnpDataMemoryFree(SnpData *snpData, long dataNum);
/* haplotype֥åΰ˳Ǽ */
int DataReaderSetHaplotypeBlockArea(FILE *fp, long *blockArea);
/* ¤Υǡե˽Ϥ */
//void DataReaderOutputAllData(FILE *fp, SnpData *snpData, long line);
/* ¤Υǡե˽Ϥ */
//void DataReaderOutputData(FILE *fp, SnpData *snpData);

/* ϥǡ¤Τ˼ */
//int DataReaderSetInputData(char *filename, InputData *inputData);
/* Ԥ֤ͤ */
//int DataReaderGetValue(FILE *fp, char *key, char *value);

/* Ĥϥǡɽ */
int DataReaderMakeTable(SnpData *snpData1, SnpData *snpData2, int **T);
/* ĤSNPalleleνؤ */
int DataReaderShiftSNPalleles(SnpData *snpData, int allele1, int allele2);
/* ĤΥǡSNPallelesν֤å */
int DataReaderCheckSNPalleles(SnpData *snpData1, SnpData *snpData2);
/* ϥǡåѤϥǡ */
long DataReaderMakeParallelData(SnpData *snpTmpData1, SnpData *snpTmpData2, long line1, long line2, SnpData **snpData1, SnpData **snpData2, char **caseData, char **controlData);

/* ϥեξե˽Ϥ */
//void DataReaderOutputHeader(FILE *fp, InputData *inputData);
/* ̤ե˽Ϥ */
//void DataReaderOutputAllResult(int level, FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, InputData *inputData, long dataNum);
/* ʬθ̤ե˽Ϥ */
//void DataReaderOutputResult(int level, FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, long repeat);
/* ̥եϡlevel0 */
//void DataReaderOutputResultLevel0(FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, long repeat);
/* ̥եϡlevel1 */
//void DataReaderOutputResultLevel1(FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData);

/* ϥǡΥץͿ */
long DataReaderGetSampleNum(FILE *fp, int dataType);
/* HapmapDataΥץ */
long DataReaderGetHapmapSampleNum(FILE *fp);
/* HaplotypeDataΥץͿ */
long DataReaderGetHaplotypeSampleNum(FILE *fp);
/* phasing줿HapmapǡΥץͿ */
long DataReaderGetPhasingHapmapSampleNum(FILE *fp);

/* HaplotypeDataԤΰҥǡ˳Ǽ */
int DataReaderSetHaplotypeSequence(FILE *fp, char **sequence, int index);
/* Haplotype٤׻ */
int DataReaderCalcHaplotypeFrequency(char **sequence, long dataNum, int L, double **frequency);
/* SnpData򥷡󥹤Ѵ */
int DataReaderSequences(SnpData *snpData, long start, long linkedSNPnum, char **sequence);

/* populationType׻ */
int DataReaderPopulationType(SnpData *snpData1, SnpData *snpData2, int *populationType);
/* ĤϥǡDiɽ */
int DataReaderMakeTableDi(SnpData *snpData1, SnpData *snpData2, int *d, int **T);
/* ĤϥǡDiɽʸƤӽФ¦ɬץǡ */
int DataReaderMakeTableDiMemoryGiven(SnpData *snpData1, SnpData *snpData2, int *d, int **T, int *data1, int *data2, int *data);
/* ʸ֤ */
char DataReaderMaximumNuc(SnpData *snpData);
/* genotype׻ */
int DataReaderCalcGenotype(SnpData *snpData, char reference, int *result);
/* Haplotype٤׻ */
long DataReaderHaplotypeFrequency(SnpData *snpData1, SnpData *snpData2, long jStart, long jEnd, char ***haplotype, double **freq);
/* SnpData򥷡󥹤Ѵ */
int DataReaderSequences(SnpData *snpData, long jStart, long jEnd, char **sequence);
/* DNAǡSnpDataѴ */
int DataReaderSequenceToSnpData(char **sequences, SnpData *snpData, long dataNum, long size);

#endif /* __HEADER_FILE_DATA_READER__ */
