#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "snp_MemoryControl.h"
#include "snp_Config.h"

static double *logFact = NULL;
static int logFactLength = 0;

int FactorialSetFactorial(int maxSize)
{
    int i = 0;
    logFactLength = maxSize;

    logFact = (double*)malloc1Dim(sizeof(double), (logFactLength + 1));
    if (NULL == logFact){
        return 1;
    }

    logFact[0] = 0;
    for (i = 1; i <= logFactLength; i++){
        logFact[i] = logFact[i-1] + log(i);
    }

    return 0;
}

double FactorialGetLogFactorial(int n)
{
    if (n > logFactLength){
        return -1;  /* Ȥꤢ-1֤JavaǤ̵֤ͤƤ */
    }
    else{
        return logFact[n];
    }
}

double FactorialGetFactorial(int n)
{
    if (n > logFactLength){
        return -1;  /* Ȥꤢ-1֤JavaǤ̵֤ͤƤ */
    }
    else{
        return exp(logFact[n]);
    }
}

double FactorialGetLogCombination(int n, int a)
{
    double logNfact = 0;
    double logAfact = 0;
    double logBfact = 0;
    double retval = 0;

    logNfact = FactorialGetLogFactorial(n);
    logAfact = FactorialGetLogFactorial(a);
    logBfact = FactorialGetLogFactorial(n-a);
    retval = logNfact - (logAfact + logBfact);

    return retval;
}

double FactorialGetCombination(int n, int a)
{
    return exp(FactorialGetLogCombination(n, a));
}

void FactorialDeleteFactorial()
{
    free1Dim(logFact);
    return;
}
