#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "snp_MemoryControl.h"
#include "snp_Config.h"

/* 1Υ */
void *malloc1Dim(int size, int dim1)
{
    int i = 0;
    void *array = NULL;

    /*  */
    array = malloc(size * dim1);
    if (NULL == array){
        printf("memory allocation error\n");
        return NULL;
    }

#ifdef DBG
    /* mallocȥå */
    malloc_count++;
#endif

    /*  */
    memset(array, 0, size * dim1 );

    return array;
}

/* int2Υ */
void **mallocInt2Dim(int dim1, int dim2)
{
    int i = 0;
    int j = 0;
    void **array = NULL;

    /*  */
    array = malloc1Dim(sizeof(int*), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = malloc1Dim(sizeof(int), dim2);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}

/* char2Υ */
void **mallocChar2Dim(int dim1, int dim2)
{
    int i = 0;
    int j = 0;
    void **array = NULL;

    /*  */
    array = malloc1Dim(sizeof(char*), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = malloc1Dim(sizeof(char), dim2 + 1);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}

/* double2Υ */
void **mallocDouble2Dim(int dim1, int dim2)
{
    int i = 0;
    int j = 0;
    void **array = NULL;

    /*  */
    array = malloc1Dim(sizeof(double*), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = malloc1Dim(sizeof(double), dim2 + 1);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}

/* int3Υ */
void ***mallocInt3Dim(int dim1, int dim2, int dim3)
{
    int i = 0;
    int j = 0;
    int k = 0;
    void ***array = NULL;

    /*  */
    array = malloc1Dim(sizeof(int**), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = mallocInt2Dim(dim2, dim3);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}


/* 1Υ곫 */
void free1Dim(void *array)
{
    if (NULL != array){
        free(array);

#ifdef DBG
        /* mallocȥ */
        malloc_count--;
#endif

    }
}

/* int2Υ곫 */
void freeInt2Dim(int **array, int dim1)
{
    int i = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                free1Dim(array[i]);
            }
        }
        free(array);

#ifdef DBG
        /* mallocȥ */
        malloc_count--;
#endif
    }
}

/* char2Υ곫 */
void freeChar2Dim(char **array, int dim1)
{
    int i = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                free1Dim(array[i]);
            }
        }
        free(array);

#ifdef DBG
        /* mallocȥ */
        malloc_count--;
#endif
    }
}

/* double2Υ곫 */
void freeDouble2Dim(double **array, int dim1)
{
    int i = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                free1Dim(array[i]);
            }
        }
        free(array);

#ifdef DBG
        /* mallocȥ */
        malloc_count--;
#endif
    }
}

/* int3Υ곫 */
void freeInt3Dim(int ***array, int dim1, int dim2)
{
    int i = 0;
    int j = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                freeInt2Dim(array[i], dim2);
            }
        }
        free(array);

#ifdef DBG
        /* mallocȥ */
        malloc_count--;
#endif
    }
}

/* molloc_count֤ */
int getMallocCount()
{
    return malloc_count;
}
