#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "snp_Permutation.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"
#include "snp_Random.h"

/* ֤򥷥åե */
int PermutationCalcOmega(int len, int* result)
{
    int *flag = NULL;
    int h = 0;
    int i = 0;
    int x = 0;
    int retval = 0;

    /* flagΥ */
    flag = (int*)malloc1Dim(sizeof(int), len);
    if (NULL == flag) {
        retval = 1;
        goto finalize;
    }

    /* 0ǽ */
    for (i = 0; i < len; i++){
        result[i] = 0;
        flag[i] = 0;
    }

    /* ֤򥷥åե뤹 */
    for (h = 0; h < len; h++){
        x = 1;
        do{
            x = (int)(myRand() * len);
            result[h] = x;
        } while(flag[x] > 0);
        flag[x]++;
    }

    /* ｪλ */
    retval = 0;

finalize:;
    /* ݤ */
	free1Dim(flag);

    return retval;
}

/* di׻ */
int PermutationCalcDi(int n, int a, int *omega, int *result)
{
    int h = 0;
    int i = 0;

    /* 0ǽ */
    for (i = 0; i< n; i++){
        result[i] = 0;
    }

    for (h = 0; h < a; h++){
        result[ omega[h] ]++;   /* 0a-1ޤǤcaseȤ */
    }

    return 0;
}

/* ɽ */
int PermutationCalcT(int *d, int *genotype, int **result, int len)
{
    int h = 0;
    int i = 0;
    int j = 0;

    /* result0ǽ */
    for (i = 0; i < ROW; i++){
        for (j = 0; j < COLUMN; j++){
            result[i][j] = 0;
        }
    }

    /* ɽ */
    for (h = 0; h < len; h++){
        result[ d[h] ][ genotype[h] ]++;
    }

    return 0;
}

int PermutationConditionedDi(int *genotype, int **T, int *result_type)
{
    int a1 = T[0][0], /* case */
        a2 = T[0][1],
        a = a1 + a2;
    int b1 = T[1][0], /* control */
        b2 = T[1][1],
        b = b1 + b2;
    int n1 = a1 + b1,
        n2 = a2 + b2,
        n = n1 + n2;

    //int *count = NULL;
    int *tmp = NULL;
    //int **num = NULL;
    int **shuffle = NULL;

    int h = 0;
    int i = 0;
    int j = 0;
    int tag = 0;
    int gen = 0;
    int retval = 0;

    /* tmpΥ */
    tmp = (int*)malloc1Dim(sizeof(int), VAL);
    if (NULL == tmp) {
        retval = 1;
        goto finalize;
    }
    tmp[0] = n1;
    tmp[1] = n2;
    ///* countΥ */
    //count = (int*)malloc1Dim(sizeof(int), VAL);
    //if (NULL == tmp) {
    //    retval = 2;
    //    goto finalize;
    //}
    ///* numΥ */
    //num = (int**)malloc1Dim(sizeof(int*), VAL);
    //if (NULL == num) {
    //    retval = 3;
    //    goto finalize;
    //}
    //for (i = 0; i < VAL; i++){
    //    num[i] = (int*)malloc1Dim(sizeof(int), tmp[i]);
    //    if (NULL == num[i]) {
    //        retval = 4;
    //        goto finalize;
    //    }
    //}
    /* shuffleΥ */
    shuffle = (int**)malloc1Dim(sizeof(int*), VAL);
    if (NULL == shuffle) {
        retval = 5;
        goto finalize;
    }
    for (i = 0; i < VAL; i++){
        shuffle[i] = (int*)malloc1Dim(sizeof(int), tmp[i]);
        if (NULL == shuffle[i]) {
            retval = 6;
            goto finalize;
        }
    }

    //for (h = 0; h < n; h++){
    //    gen = genotype[h];
    //    num[gen][ count[gen] ] = h;
    //    count[gen]++;
    //}
    /* ¿ΰҷбǤ褦˾Ūˤϳĥ */

    /* ؤ */
    for(gen = 0; gen < VAL; gen++){
        retval = PermutationCalcOmega(tmp[gen], shuffle[gen]);
    }

    /* ٿ˹碌casecontrol꿶 */
    for (gen = 0; gen < 2; gen++){
        for (h = 0; h < tmp[gen]; h++){
            tag = shuffle[gen][h];
            if (h < T[0][gen]){
                result_type[tag] = 0;
            }
            else{
                result_type[tag] = 1;
            }
        }
    }

    /* ｪλ */
    retval = 0;

finalize:;
    /* ݤ */
	free1Dim(tmp);
	//free1Dim(count);
    //freeInt2Dim(num, VAL);
    freeInt2Dim(shuffle, VAL);

	return retval;
}
