#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef MPI_USE
#include <mpi.h>
#endif

#define _MAIN_DEF

//#include "snp_typeIParallel.h"
#include "snp_typeI.h"

#ifdef MPI_USE
/* ץȥ */
int Define_MPI_InputStruct(MPI_Datatype *mpi_inputStruct);
#endif

/** MPIν
 *  MPIѤΰơ롣
 *  @param argc [IN/OUT] ο
 *  @param argv [IN/OUT] 
 */
void setupMPI(int *argc, char ***argv)
{
#ifdef MPI_USE
    MPI_Init(argc, argv);
    MPI_Comm_size(MPI_COMM_WORLD, &MyMpiSize);
    MPI_Comm_rank(MPI_COMM_WORLD, &MyMpiRank);
#else
    MyMpiSize = 1;
    MyMpiRank = 0;
#endif /* MPI_USE */
}


int main(int argc, char* argv[])
{
    InputTypeI inputTypeI={"", "", "", 0, "", 0, 0, 0, 0};

    int i = 0;

    /* MPIˤ */
    setupMPI(&argc, &argv);

#ifdef MPI_USE
    /* ַ¬ѿν */
    for (i = 0; i < NUM_TM; i++){
        tm[i] = 0.0;
    }

    /* ַ¬ */
    tm[TM_START] = MPI_Wtime();
#endif /* MPI_USE */

    if(argc != 10){
        printf("[usage]main.exe [InputFile1] [InputFile2] [outputFile] [AreaFileType] [BlockAreaFile] [Score] [Repeat] [Generation] [dataType] \n");
        return 255;
    }
    strcpy(inputTypeI.inputFile1, argv[1]);
    strcpy(inputTypeI.inputFile2, argv[2]);
    strcpy(inputTypeI.outputFile1, argv[3]);
    inputTypeI.areaFileType = atoi(argv[4]);
    strcpy(inputTypeI.blockAreaFile, argv[5]);
    inputTypeI.score = atoi(argv[6]);
    inputTypeI.repeat = atol(argv[7]);
    inputTypeI.gen = atol(argv[8]);
    inputTypeI.dataType = atoi(argv[9]);

    if (MyMpiRank == 0) {
        printf("inputFile1: %s\n", inputTypeI.inputFile1);
        printf("inputFile2: %s\n", inputTypeI.inputFile2);
        printf("outputFile1: %s\n", inputTypeI.outputFile1);
        printf("blockAreaFile: %s\n", inputTypeI.blockAreaFile);
        printf("score: %d\n", inputTypeI.score);
        printf("repeat: %ld\n", inputTypeI.repeat);
        printf("gen: %ld\n", inputTypeI.gen);
        printf("dataType: %d\n", inputTypeI.dataType);
        printf("MyMpiSize: %d\n", MyMpiSize);
    }

    /* ׻ˡλ */
    iWay = inputTypeI.score;

    /* ȯؿ */
    initMyRand();

    /* MultiLocusԤ */
    MainProgramMulti(&inputTypeI);

#ifdef MPI_USE
    /* ַ¬ */
    tm[TM_END] = MPI_Wtime();

    MPI_Finalize();    /* MPIλ */

    printf("%4d  1 time Init-READ      %lf (sec)\n", MyMpiRank, tm[TM_B_READ]     - tm[TM_START]);
    printf("%4d  2 time READ           %lf (sec)\n", MyMpiRank, tm[TM_A_READ]     - tm[TM_B_READ]);
    printf("%4d  3 time READ-FBcast    %lf (sec)\n", MyMpiRank, tm[TM_B_F_BCAST]  - tm[TM_A_READ]);
    printf("%4d  4 time FBcast         %lf (sec)\n", MyMpiRank, tm[TM_A_F_BCAST]  - tm[TM_B_F_BCAST]);
    printf("%4d  5 time FBcast-Bcast   %lf (sec)\n", MyMpiRank, tm[TM_B_BCAST]    - tm[TM_A_F_BCAST]);
    printf("%4d  6 time Bcast          %lf (sec)\n", MyMpiRank, tm[TM_A_BCAST]    - tm[TM_B_BCAST]);
    printf("%4d  7 time Bcast-Calc     %lf (sec)\n", MyMpiRank, tm[TM_B_CALC]     - tm[TM_A_BCAST]);
    printf("%4d  8 time Calculation    %lf (sec)\n", MyMpiRank, tm[TM_A_CALC]     - tm[TM_B_CALC]);
    printf("%4d  9 time Calc-FGather   %lf (sec)\n", MyMpiRank, tm[TM_B_F_GATHER] - tm[TM_A_CALC]);
    printf("%4d 10 time FGather        %lf (sec)\n", MyMpiRank, tm[TM_A_F_GATHER] - tm[TM_B_F_GATHER]);
    printf("%4d 11 time FGather-Gather %lf (sec)\n", MyMpiRank, tm[TM_B_GATHER]   - tm[TM_A_F_GATHER]);
    printf("%4d 12 time Gather         %lf (sec)\n", MyMpiRank, tm[TM_A_GATHER]   - tm[TM_B_GATHER]);
    printf("%4d 13 time Gather-Write   %lf (sec)\n", MyMpiRank, tm[TM_B_WRITE]    - tm[TM_A_GATHER]);
    printf("%4d 14 time Write          %lf (sec)\n", MyMpiRank, tm[TM_A_WRITE]    - tm[TM_B_WRITE]);
    printf("%4d 15 time Write-End      %lf (sec)\n", MyMpiRank, tm[TM_END]        - tm[TM_A_WRITE]);

    printf("%4d 20 time Init           %lf (sec)\n", MyMpiRank, tm[TM_B_F_BCAST]  - tm[TM_START]);
    printf("%4d 21 time FBcast         %lf (sec)\n", MyMpiRank, tm[TM_B_BCAST]    - tm[TM_B_F_BCAST]);
    printf("%4d 22 time Bcast          %lf (sec)\n", MyMpiRank, tm[TM_B_CALC]     - tm[TM_B_BCAST]);
    printf("%4d 23 time Calculation    %lf (sec)\n", MyMpiRank, tm[TM_A_CALC]     - tm[TM_B_CALC]);
    printf("%4d 24 time Gather         %lf (sec)\n", MyMpiRank, tm[TM_A_GATHER]   - tm[TM_A_CALC]);
    printf("%4d 25 time End            %lf (sec)\n", MyMpiRank, tm[TM_END]        - tm[TM_A_GATHER]);

    printf("%4d 30 time Calculation    %lf (sec)\n", MyMpiRank, tm[TM_A_CALC]     - tm[TM_B_CALC]);
    printf("%4d 31 time F_Bcast-Gather %lf (sec)\n", MyMpiRank, tm[TM_A_GATHER]   - tm[TM_B_F_BCAST]);
    printf("%4d 32 time A_Read-B_Write %lf (sec)\n", MyMpiRank, tm[TM_A_WRITE]    - tm[TM_B_READ]);
    printf("%4d 33 time Total          %lf (sec)\n", MyMpiRank, tm[TM_END]        - tm[TM_START]);
#endif /* MPI_USE */

    return 0;
}


/* MultiLocusԤ */
void MainProgramMulti(InputTypeI *inputTypeI)
{
    int retval = 0;
    int flag = 0;
    int numOutput = 0;
    int outDataOffset = 0;
    int numPartOutput = 0;
    int numTIEPartOutput = 0;
    long i = 0;
	long j = 0;
    long k = 0;
    long fileLine1 = 0; /* ϥեΥ饤 */
    long fileLine2 = 0; /* ϥեΥ饤 */
    long areaFileLine = 0; /* haplotype֥åΰեΥ饤 */
    long a = 0;         /* number of haplotype copies (=sequences) in case */
    long b = 0;         /* number of haplotype copies (=sequences) in control */
    long n = 0;
    long dataNum;       /* casecontrolǡSNP */
    long index = 0;
    long jStart = 0;    /* haplotype֥åκǽSNP򼨤° */
    long jEnd = 0;      /* haplotype֥åκǸSNP򼨤° */
    long blockNum = 0;  /* haplotype֥å */
    long repeat = 0;
    long startPos = 0;
    long endPos = 0;
    long blockPartNum = 0;
    long blockPartStart = 0;
    double S = 0;

    /* Gather */
    int *numOutputs = NULL;
    int *outDataOffsets = NULL;
    int *outTIEOutputs = NULL;
    int *outTIEDataOffsets = NULL;
    int *numTIEOutputs = NULL;
    int **T = NULL;                 /* ɽ */
    int *populationType = NULL;
    char ***haplotype = NULL;       /* haplotypeǡ */
    char *caseData = NULL;          /* ץǡcase˳Ǽ */
    char *controlData = NULL;       /* ץǡcontrol˳Ǽ */
    long *L = NULL;                 /* haplotype֥åhaplotypeѥ */
    long *blockArea = NULL;         /* haplotype֥åΰǼ */
    long *linkSNPNum = NULL;        /* haplotype֥åSNP */
    long *linkSNPStart = NULL;      /* haplotype֥åκǽSNP򼨤° */
    long *maxScoreIndex = NULL;     /* haplotype֥åΥͤκ° */
    long *maxScoreIndexAll = NULL;  /* Haplotype֥åΥͤκ° */
    double **freq = NULL;           /*  */
    double *typeIError = NULL;      /* type I error Ǽ */
    double *typeIErrorAll = NULL;   /* type I error Ǽ */
    double *Sobs = NULL;            /* haplotype֥åΥ */
    double *SobsAll = NULL;         /* Haplotype֥åΥ */

    FILE *fpCase = NULL;            /* ϡcase˥եݥ */
    FILE *fpCntl = NULL;            /* ϡcontrol˥եݥ */
    FILE *fpOut = NULL;             /* ϥեݥ */
    FILE *fpArea = NULL;            /* haplotype֥åΰեݥ */

    SnpData *snpTmpData1 = NULL;
    SnpData *snpTmpData2 = NULL;
    SnpData *snpData1 = NULL;
    SnpData *snpData2 = NULL;

#ifdef MPI_USE
    /* MPIѹ¤ */
    MPI_Datatype MPI_INPUT_STRUCT;
#endif /* MPI_USE */

    repeat = inputTypeI->repeat;

/****************************************************************/
/* ǡ                                                   */
/****************************************************************/

#ifdef MPI_USE
    /* ַ¬ */
    tm[TM_B_READ] = MPI_Wtime();
#endif /* MPI_USE */

    /* rank0Τ߼¹ */
    if (MyMpiRank == 0) {
        /* ե륪ץ */
        retval = InputFileOpen(&fpCase, inputTypeI->inputFile1);
        if (retval != 0){
            goto finalize;
        }
        retval = InputFileOpen(&fpCntl, inputTypeI->inputFile2);
        if (retval != 0){
            goto finalize;
        }
        retval = OutputFileOpen(&fpOut, inputTypeI->outputFile1);
        if (retval != 0){
            goto finalize;
        }
        retval = InputFileOpen(&fpArea, inputTypeI->blockAreaFile);
        if (retval != 0){
            goto finalize;
        }

        /* ϥեΥ饤 */
        fileLine1 = DataReaderCountFileLine(fpCase);
        fileLine2 = DataReaderCountFileLine(fpCntl);

        /* եݥ󥿤Ƭ᤹ */
        fseek(fpCase, 0L, SEEK_SET);
        fseek(fpCntl, 0L, SEEK_SET);

        /* ǡǼѹ¤ΤΥ */
        snpTmpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine1);
        if (NULL == snpTmpData1){ goto finalize; }
        snpTmpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine2);
        if (NULL == snpTmpData2){ goto finalize; }

        /* ǡե뤫ɤ߹߹¤Τ˼ */
        DataReaderSetAllData(fpCase, snpTmpData1, fileLine1, inputTypeI->dataType);
        DataReaderSetAllData(fpCntl, snpTmpData2, fileLine2, inputTypeI->dataType);

        /* ϥǡåѤϥǡ */
        /* MPI_Bcastβ򸺤餹˥ץǡcaseData, controlDataˤݻ */
        dataNum = DataReaderMakeParallelData(snpTmpData1, snpTmpData2, fileLine1, fileLine2, &snpData1, &snpData2, &caseData, &controlData);

        /* ѤʤΥ곫 */
        /* ¤SnpDataФΥ */
        DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
        DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
        snpTmpData1 = NULL;
        snpTmpData2 = NULL;
 
        /* haplotype֥åΰեΥ饤 */
        areaFileLine = DataReaderCountFileLine(fpArea);
        /* haplotype֥åΰǼΥ */
        blockArea = (long*)malloc1Dim(sizeof(long), areaFileLine);
        if (NULL == blockArea){ goto finalize; }
        /* եݥ󥿤Ƭ᤹ */
        fseek(fpArea, 0L, SEEK_SET);
        /* haplotype֥åΰ˼ */
        DataReaderSetHaplotypeBlockArea(fpArea, blockArea);
        /* haplotype֥å */
        if (inputTypeI->areaFileType == 0){
            blockNum = areaFileLine - 1;
        }
        else {
            /* haplotype֥åθĿ׻ */
            if (blockArea[0] > dataNum){
                blockNum = 1;
                blockArea[1] = dataNum; /* linkSNPNumͤǡˤʤ */
            }
            else{
                blockNum = (dataNum - (blockArea[0] - blockArea[1]) ) / blockArea[1];
            }
        }
    }/* rank0Τ߼¹Ԥޤ */

#ifdef MPI_USE
    /* ַ¬ */
    tm[TM_A_READ] = MPI_Wtime();
    /* ַ¬ */
    tm[TM_B_F_BCAST] = MPI_Wtime();

    /* ǡȥ֥å */
    MPI_Bcast(&dataNum, 1, MPI_LONG, 0, MPI_COMM_WORLD);
    MPI_Bcast(&blockNum, 1, MPI_LONG, 0, MPI_COMM_WORLD);
    MPI_Bcast(&areaFileLine, 1, MPI_LONG, 0, MPI_COMM_WORLD);

    /* ַ¬ */
    tm[TM_A_F_BCAST] = MPI_Wtime();

    if (MyMpiSize > blockNum) {
        /* rank0Τ߼¹ */
        if (MyMpiRank == 0) {
            fprintf(stderr, "ץå(%d)ǡ֥å(%ld)¿ꤵƤޤ.\n", MyMpiSize, blockNum);
        }
        MPI_Abort(MPI_COMM_WORLD, 1);
        goto finalize;
    }
    if (MyMpiSize > dataNum) {
        /* rank0Τ߼¹ */
        if (MyMpiRank == 0) {
            fprintf(stderr, "ץå(%d)ǡ(%ld)¿ꤵƤޤ.\n", MyMpiSize, dataNum);
        }
        MPI_Abort(MPI_COMM_WORLD, 1);
        goto finalize;
    }

    /* 0ʳϥǡΥ */
    if (MyMpiRank != 0) {
        /* snpData1caseˤΥ */
        snpData1 = (SnpData *)malloc1Dim(sizeof(SnpData), dataNum);
        if (snpData1 == NULL) {
            fprintf(stderr, "rank:%d ݤǤޤǤ.\n", MyMpiRank);
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
        /* snpData2controlˤΥ */
        snpData2 = (SnpData *)malloc1Dim(sizeof(SnpData), dataNum);
        if (snpData2 == NULL) {
            fprintf(stderr, "rank:%d ݤǤޤǤ.\n", MyMpiRank);
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
        /* haplotype֥åΰΥ */
        blockArea = (long*)malloc1Dim(sizeof(long), areaFileLine);
        if (blockArea == NULL) {
            fprintf(stderr, "rank:%d ݤǤޤǤ.\n", MyMpiRank);
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
    }

    /* MPIѷ */
    Define_MPI_InputStruct(&MPI_INPUT_STRUCT);

    /* ַ¬ */
    tm[TM_B_BCAST] = MPI_Wtime();

    /* ϥǡ(¤)Υ֥ɥ㥹 */
    MPI_Bcast(snpData1, dataNum, MPI_INPUT_STRUCT, 0, MPI_COMM_WORLD);
    MPI_Bcast(snpData2, dataNum, MPI_INPUT_STRUCT, 0, MPI_COMM_WORLD);
    MPI_Bcast(blockArea, areaFileLine, MPI_LONG, 0, MPI_COMM_WORLD);
#endif /* MPI_USE */

    /* ϥǡΥץ */
    a = snpData1[0].dataNum;
    b = snpData2[0].dataNum;
    n = a + b;

#ifdef MPI_USE
    /* 0ʳϥǡΥ */
    if (MyMpiRank != 0) {
        /* ץǡcase˳ǼѤΥ */
        caseData = (char *)malloc1Dim(sizeof(char), dataNum * a);
        if (caseData == NULL) {
            fprintf(stderr, "rank:%d ݤǤޤǤ.\n", MyMpiRank);
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
        /* ץǡcontrol˳ǼѤΥ */
        controlData = (char *)malloc1Dim(sizeof(char), dataNum * b);
        if (controlData == NULL) {
            fprintf(stderr, "rank:%d ݤǤޤǤ.\n", MyMpiRank);
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
    }

    /* ϥǡ(ǡ)Υ֥ɥ㥹 */
    MPI_Bcast(caseData, dataNum * a, MPI_CHAR, 0, MPI_COMM_WORLD);
    MPI_Bcast(controlData, dataNum * b, MPI_CHAR, 0, MPI_COMM_WORLD);

    /* ַ¬ */
    tm[TM_A_BCAST] = MPI_Wtime();
#endif /* MPI_USE */

    /* ¤SnpData˥ץǡ򥳥ԡ */
    DataReaderDataCopyToSnpData(snpData1, caseData, dataNum, a);
    DataReaderDataCopyToSnpData(snpData2, controlData, dataNum, b);

/****************************************************************/
/*                                                    */
/****************************************************************/

    /* ץåȤΥǡĿ׻ */
    blockPartNum = blockNum / MyMpiSize;
    if (MyMpiRank < blockNum % MyMpiSize) {
        blockPartNum++;
    }
    /* ƥץåˤǡΥեåͤη׻ */
    if (MyMpiRank < blockNum % MyMpiSize) {
        blockPartStart = blockPartNum * MyMpiRank;
    }
    else{
        blockPartStart = (blockPartNum + 1) * (blockNum % MyMpiSize)
                       + blockPartNum * (MyMpiRank - blockNum % MyMpiSize);
    }

    /* haplotype֥åΰSNPǼΥ */
    linkSNPNum = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPNum){ goto finalize; }
    /* haplotype֥åΰκǽSNP򼨤°̳ǼΥ */
    linkSNPStart = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPStart){ goto finalize; }

    /* haplotype֥åΰ˳SNPǡ */
    if (inputTypeI->areaFileType == 0){
        for (i = 0; i < blockNum; i++){ /* 衢ΰνʣͤ */
            startPos = blockArea[i];
            endPos = blockArea[i+1];
            flag = 0;
            /* ϥǡϥݥǥȤƤȲ */
            for (j = 0; j < dataNum; j++){
                if (startPos <= snpData1[j].pos){
                    if (snpData1[j].pos < endPos){
                        /* ΰSNP */
                        linkSNPNum[i]++;
                        /* ΰκǽSNP򼨤°̤ݻ */
                        if (0 == flag ){
                            linkSNPStart[i] = j;
                            flag = 1;
                        }
                    }
                    /* ʹߡΰ˳ǡϽиʤΤǼΥ֥åĴ٤ */
                    else {
                        break;
                    }
                }
            }
        }
    }
    else {
        for (i = 0; i < blockNum; i++){
            linkSNPNum[i] = blockArea[0];
            linkSNPStart[i] = i * blockArea[1];
        }
    }

    /* ɽTΥ */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }
    /* populationTypeΥ */
    populationType = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == populationType) { goto finalize; }
    /* type I error ǼΥ */
    typeIError = (double*)malloc1Dim(sizeof(double), blockPartNum * repeat);
    if (NULL == typeIError) { goto finalize; }
    /* haplotypeǡΥ */
    haplotype = (char***)malloc1Dim(sizeof(char**), blockPartNum);
    if (NULL == haplotype) { goto finalize; }
    /* ѥ٤Υ */
    freq = (double**)malloc1Dim(sizeof(double*), blockPartNum);
    if (NULL == freq) { goto finalize; }
    /* ѥΥ */
    L = (long*)malloc1Dim(sizeof(long), blockPartNum);
    if (NULL == L) { goto finalize; }
    /* Haplotype֥åΥͤκ°̤Υ */
    maxScoreIndex = (long*)malloc1Dim(sizeof(long), blockPartNum);
    if (NULL == maxScoreIndex) { goto finalize; }
    /* Haplotype֥åΥͤΥ */
    Sobs = (double*)malloc1Dim(sizeof(double), blockPartNum);
    if (NULL == Sobs) { goto finalize; }

/****************************************************************/
/*                                                      */
/****************************************************************/

#ifdef MPI_USE
    /* ַ¬ */
    tm[TM_B_CALC] = MPI_Wtime();
#endif /* MPI_USE */

    /* haplotype֥åñ̤ǥ롼 */
    jStart = 0;
    for (i = 0, k = blockPartStart; i < blockPartNum; i++, k++){
        jStart = linkSNPStart[k];
        jEnd = jStart + linkSNPNum[k];
        /* haplotype֥åǥ롼 */
        for (j = jStart; j < jEnd; j++){
            /* ¬ͤɽ */
            DataReaderPopulationType(&snpData1[j], &snpData2[j], populationType);
            DataReaderMakeTableDi(&snpData1[j], &snpData2[j], populationType, T);
            /* ׻׻0ˤʤäƤޤ-1֤ */
            S = TableCalcScore(T);
            /* 祹ꤹ */
            if (S > Sobs[i]){
                Sobs[i] = S;
                maxScoreIndex[i] = j;
            }
        }
        /* Haplotype٤׻ */
        L[i] = DataReaderHaplotypeFrequency(snpData1, snpData2, jStart, jEnd, &haplotype[i], &freq[i]);

        /* ϥץ״ϢϤType I errorγΨ׻¹Ԥ */
        if (Sobs[i] > 0.0) {
            TypeIExecute(freq[i], haplotype[i], L[i], Sobs[i], a, b, linkSNPNum[k], &typeIError[i*repeat], repeat, inputTypeI->gen);
        }
    }

#ifdef MPI_USE
    /* ַ¬ */
    tm[TM_A_CALC] = MPI_Wtime();

    if (MyMpiRank == 0) {
        /* ƥ󥯤Υ֥åǼΥ */
        numOutputs = (int *)malloc1Dim(sizeof(int), MyMpiSize);
        if (numOutputs == NULL) {
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
        /* ƥ󥯥ǡΥեåͤǼΥ */
        outDataOffsets = (int *)malloc1Dim(sizeof(int), MyMpiSize);
        if (outDataOffsets == NULL) {
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
        /* ƥ󥯤TypeIerror׻̿ǼΥ */
        numTIEOutputs = (int *)malloc1Dim(sizeof(int), MyMpiSize);
        if (numTIEOutputs == NULL) {
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
        /* ƥ󥯤TypeIerro׻̤ΥեåͤǼ */
        outTIEDataOffsets = (int *)malloc1Dim(sizeof(int), MyMpiSize);
        if (outTIEDataOffsets == NULL) {
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
    }

    /* ַ¬ */
    tm[TM_B_F_GATHER] = MPI_Wtime();

    numOutput = blockPartNum;

    /* ƥ󥯤׻ͤθĿ */
    MPI_Gather(&numOutput, 1, MPI_INT, numOutputs, 1,MPI_INT, 0, MPI_COMM_WORLD);

    /* ַ¬ */
    tm[TM_A_F_GATHER] = MPI_Wtime();

    if (MyMpiRank == 0) {
        /* TypeIErrorθĿ */
        for (i = 0; i < MyMpiSize; i++) {
            numTIEOutputs[i] = numOutputs[i] * repeat;
        }

        /* 󥯤ȤΥǡΥեåͤη׻ */
        outDataOffsets[0] = 0;
        outTIEDataOffsets[0] = 0;
        for (i = 1; i < MyMpiSize; i++) {
            outDataOffsets[i] = outDataOffsets[i-1] + numOutputs[i-1];
            outTIEDataOffsets[i] = outTIEDataOffsets[i-1] + numOutputs[i-1] * repeat;
        }

        /* ѥǡǼ빽¤Υ */
        SobsAll = (double *)malloc1Dim(sizeof(double), blockNum);
        maxScoreIndexAll = (long *)malloc1Dim(sizeof(long), blockNum);
        typeIErrorAll = (double *)malloc1Dim(sizeof(double), blockNum * repeat);
    }

    /* ַ¬ */
    tm[TM_B_GATHER] = MPI_Wtime();

    /* ƥץåΥǡμ */
    MPI_Gatherv(Sobs, numOutput, MPI_DOUBLE, SobsAll,
               numOutputs, outDataOffsets, MPI_DOUBLE, 0, MPI_COMM_WORLD);
    MPI_Gatherv(maxScoreIndex, numOutput, MPI_LONG, maxScoreIndexAll,
               numOutputs, outDataOffsets, MPI_LONG, 0, MPI_COMM_WORLD);
    MPI_Gatherv(typeIError, numOutput * repeat, MPI_DOUBLE, typeIErrorAll,
               numTIEOutputs, outTIEDataOffsets, MPI_DOUBLE, 0, MPI_COMM_WORLD);

    /* ַ¬ */
    tm[TM_A_GATHER] = MPI_Wtime();


    /* ַ¬ */
    tm[TM_B_WRITE] = MPI_Wtime();
#else
    /* ݥMPI_GathervΤ */
    SobsAll = Sobs;
    maxScoreIndexAll = maxScoreIndex;
    typeIErrorAll = typeIError;
#endif /* MPI_USE */

/****************************************************************/
/* ̽                                                 */
/****************************************************************/

    if (MyMpiRank == 0) {
        fprintf(fpOut, "CaseData    = %s\n", inputTypeI->inputFile1);
        fprintf(fpOut, "ControlData = %s\n", inputTypeI->inputFile2);
        fprintf(fpOut, "Repeat      = %ld\n", inputTypeI->repeat);
        fprintf(fpOut, "Genoration  = %ld\n", inputTypeI->gen);
        fprintf(fpOut, "BlockArea\tSNPNum\trsNumber\tPosition\tScore\tTypeIerror...\n");
        if (inputTypeI->areaFileType == 0){
            for (i = 0; i < blockNum; i++){
                if (SobsAll[i] != 0){
                    fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.3e\t", 
                            blockArea[i],
                            blockArea[i+1],
                            linkSNPNum[i],
                            snpData1[ maxScoreIndexAll[i] ].rsNumber,
                            snpData1[ maxScoreIndexAll[i] ].pos,
                            SobsAll[i]);
                    /* type I error */
                    for (index = 0; index < repeat; index++){
                        fprintf(fpOut, "%.3e\t", typeIErrorAll[i*repeat+index]);
                    }
                    fprintf(fpOut, "\n");
                }
                else {
                    fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                            blockArea[i],
                            blockArea[i+1],
                            linkSNPNum[i]);
                }
            }
        }
        else {
            for (i = 0; i < blockNum; i++){
                if (SobsAll[i] != 0){
                    fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.3e\t", 
                            snpData1[ linkSNPStart[i] ].pos,
                            snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                            linkSNPNum[i],
                            snpData1[ maxScoreIndexAll[i] ].rsNumber,
                            snpData1[ maxScoreIndexAll[i] ].pos,
                            SobsAll[i]);
                    /* type I error */
                    for (index = 0; index < repeat; index++){
                        fprintf(fpOut, "%.3e\t", typeIErrorAll[i*repeat+index]);
                    }
                    fprintf(fpOut, "\n");
                }
                else {
                    fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                            snpData1[ linkSNPStart[i] ].pos,
                            snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                            linkSNPNum[i]);
                }
            }
        }
    }

#ifdef MPI_USE
    /* ַ¬ */
    tm[TM_A_WRITE] = MPI_Wtime();
#endif /* MPI_USE */

/****************************************************************/
/* λ                                                     */
/****************************************************************/

finalize:;
    /* ե륯 */
    FileClose(fpCase);
    FileClose(fpCntl);
    FileClose(fpOut);
    FileClose(fpArea);
    /* ݤ */
    // haplotypeѿcharΣ
    // ǿL狼롣ʸlinkedSNPNumǤ롣
    // Ѥγδؿɬפ롣Ȥꤢ̤free
    for (i = blockPartNum-1; i >= 0; i--){
        for (index = L[i]-1; index >= 0; index--){
            free1Dim(haplotype[i][index]);
        }
        free1Dim(haplotype[i]);
    }
    free1Dim(haplotype);

#ifdef MPI_USE
    free1Dim(numOutputs);
    free1Dim(outDataOffsets);
    free1Dim(outTIEOutputs);
    free1Dim(outTIEDataOffsets);
    free1Dim(numTIEOutputs);

    free1Dim(SobsAll);
    free1Dim(typeIErrorAll);
    free1Dim(maxScoreIndexAll);
#endif /* MPI_USE */

    free1Dim(blockArea);
    free1Dim(linkSNPNum);
    free1Dim(linkSNPStart);
    free1Dim(typeIError);
    freeDouble2Dim(freq,blockPartNum);
    freeInt2Dim(T, ROW);
    free1Dim(populationType);
    free1Dim(L);
    free1Dim(maxScoreIndex);
    free1Dim(Sobs);
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    free1Dim(caseData);
    free1Dim(controlData);
    free1Dim(snpData1);
    free1Dim(snpData2);

    return;
}

/* ϥץ״ϢϤType I errorγΨ׻¹Ԥ */
int TypeIExecute(double *freq, char **haplotype, long L, double Sobs, long a, long b, long dataNum, double *typeIError, long repeat, long gen)
{
    int burnin = 100000; //10ѹ
    int **X = NULL;
    int flag = 0;
    long j = 0;
    long m = 0;
    long n = 0;
    long pop = 0;
    long copyNumber = 0;

    double S = 0;
    double total = 0;
    double diff = 0;

    // ǻꤹ褦ѹ
    //double gen = 100000;

    int **Tresample = NULL;             /* ɽ */
    int *populationType = NULL;
    char **sequences = NULL;

    /* add 2010.11.10 Ȥޤ路ѥΰǼѿɲ */
    int *data = NULL;
    int *data1 = NULL;
    int *data2 = NULL;

    SnpData *resampledData1 = NULL;
    SnpData *resampledData2 = NULL;

    copyNumber = a + b;

    /* add 2010.11.10 Ȥޤ路ѥΰ */
    /* dataΥ */
    data = (int*)malloc1Dim(sizeof(int), a + b);
    if (NULL == data) { goto finalize; }
    /* data1Υ */
    data1 = (int*)malloc1Dim(sizeof(int), a);
    if (NULL == data1) { goto finalize; }
    /* data2Υ */
    data2 = (int*)malloc1Dim(sizeof(int), b);
    if (NULL == data2) { goto finalize; }

    /* ǡǼѹ¤ΤΥ */
    resampledData1 = (SnpData*)malloc1Dim(sizeof(SnpData), dataNum);
    resampledData2 = (SnpData*)malloc1Dim(sizeof(SnpData), dataNum);
    DataReaderSnpDataMemoryAllocate(resampledData1, dataNum, a);
    DataReaderSnpDataMemoryAllocate(resampledData2, dataNum, b);
    /* sequencesΥ */
    sequences = (char**)mallocChar2Dim(a + b, dataNum);
    if (NULL == sequences) { goto finalize; }
    /* ɽTresampleΥ */
    Tresample = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == Tresample){ goto finalize; }
    /* populationTypeΥ */
    populationType = (int*)malloc1Dim(sizeof(int), a + b);
    if (NULL == populationType) { goto finalize; }

    //for (burnin = 0; burnin < 1 + gen * 0; burnin += 100000){ //burninǥ롼פʤ褦ѹ
        /*  */
        X = (int**)mallocInt2Dim(2, L);
        if (NULL == X) { goto finalize; }

        /* procedure 2 */
        //TypeIStartSet2(a, L, X[0]);
        //TypeIStartSet2(b, L, X[1]);
        TypeIStartSet(a, freq, L, X[0]);
        TypeIStartSet(b, freq, L, X[1]);

        /* start Markov */
        /* burn in */
        for (m = 0; m < burnin; m++){
            TypeIMarkov(X, freq, L);
        }

        for (n = 0; n < repeat; n++){
            diff = 0;
            for (m = 0; m < gen; m++){
                total++;
                TypeIMarkov(X, freq, L);

                /* ϥץפXɽƤ */
                TypeISampling(X[0], haplotype, dataNum, L, sequences);
                /* DNAǡSnpDataѴ */
                DataReaderSequenceToSnpData(sequences, resampledData1, dataNum, a);
                /* ϥץפXɽƤ */
                TypeISampling(X[1], haplotype, dataNum, L, sequences);
                /* DNAǡSnpDataѴ */
                DataReaderSequenceToSnpData(sequences, resampledData2, dataNum, b);

                /* ե饰 */
                flag = 0;
                for (j = 0; j < dataNum; j++){
                    /* ¬ͤɽ */
                    DataReaderPopulationType(&resampledData1[j], &resampledData2[j], populationType);
                    /* mod 2010.11.10 Ȥޤ魯ǤδؿƤӽФ */
                    DataReaderMakeTableDiMemoryGiven(&resampledData1[j], &resampledData2[j], populationType, Tresample, data1, data2, data);
                    //DataReaderMakeTableDi(&resampledData1[j], &resampledData2[j], populationType, Tresample);
                    /* ׻׻0ˤʤäƤޤ-1֤ */
                    S = TableCalcScore(Tresample);
                    /* 祹ꤹ */
                    if (S >= Sobs) {
                        diff++;
                        /* S>=SobsȽ̤ե饰򤿤Ƥ */
                        flag = 1;
                    }
                }
                /* İʾ㤤Ȥ˰ĥ */
                if (flag > 0){
                    diff++;
                }
            }
            typeIError[n] = diff/gen;
            /* ǧɸ */
            //printf("%d\t%d\t%d\t%d\t%d\t%lf\n", n+1, a, b, copyNumber, burnin, diff/gen);
        }
    //}

finalize:;
    /* ݤ */
    freeInt2Dim(X, 2);
    freeChar2Dim(sequences, a + b);
    free1Dim(resampledData1);
    free1Dim(resampledData2);
    
    /* add 2010.11.10 ݤȤޤ路ѥΰ */
    free1Dim(data);
    free1Dim(data1);
    free1Dim(data2);

    return 0;
}

/* MCMC¹ */
void TypeIMarkov(int **X, double *h, long L)
{
    int j = 0;
    long u = 0;
    long v = 0;
    int XjuStar = 0;
    int XjvStar = 0;

    double c = 0;
    double tmp = 0;

    /* procedure 3 */
    j = TypeIZeroOne();

    /* procedure 4 */
    u = (int)(myRand() * L);

    if (0 == X[j][u]){ /* condition 5 */
        /* invariant */
    }
    else{ /* condition 6 */
        v = 0;
        do{
            v = (int)(myRand() * L);
        } while(u == v);
        
        /* new candidate */
        XjuStar = X[j][u] - 1;
        XjvStar = X[j][v] + 1;

        /* transition probability */
        c = h[v] * X[j][u] / (h[u] * (X[j][v] +1));

        if (c >= 1){ /* condition 8 */
            X[j][u] = XjuStar;
            X[j][v] = XjvStar;
        }
        else{
            tmp = myRand();
            if (tmp < c){
                X[j][u] = XjuStar;
                X[j][v] = XjvStar;
            }
        }

        /* procedure 10 */
    }
}

/* ǽhaplotypeȤå */
int TypeIStartSet2(long sampleSize, long L, int *result)
{
    long i = 0;
    long sum = 0;

    /*  */
    for(i = 0; i < L; i++){
        result[i] = 0;
    }

    result[0] = sampleSize;

    return 0;
}

/* ٤㤵ǽΥåȤ */
int TypeIStartSet(long sampleSize, double *frequency, long L, int *result)
{
    long i = 0;
    long sum = 0;

    /*  */
    for(i = 0; i < L; i++){
        result[i] = 0;
    }

    i = 0;
    for (i = 0; i < sampleSize; i++){
        result[ TypeIDiscreteRandomValue(frequency, L) ]++;
    }

    return 0;
}

/* ٤㤷֤ͤ */
long TypeIDiscreteRandomValue(double *xlist, long len)
{
    long i = 0;
    long num = 0;
    double x = 0;
    double all = 0;
    double tmp = 0;

    for (i = 0; i < len; i++){
        all += xlist[i];
    }
    x = myRand() * all;

    for (i = 0; i < len; i++){
        tmp += xlist[i];
        if (x > tmp){
            num++;
        }
    }

    return num;
}

/* Ψ1/201֤ */
int TypeIZeroOne()
{
    /* return 0 or 1 with probability 0.5 */
    int result = 0;

    result = (int)(myRand() * 2);

    return result;
}



/* ϥץפXɽƤ */
int TypeISampling(int *X, char **haplotype, long dataNum, long L, char **sequences)
{
    /* dataNumSNP */
    /* Lϥץפοʼο */
    long tmp = 0;
    long h = 0;
    long h2 = 0;

    for (h = 0; h < L; h++){
        for (h2 = 0; h2 < X[h]; h2++){
            strncpy(sequences[tmp], haplotype[h], dataNum);
            tmp++;
        }
    }

    return 0;
}

#ifdef MPI_USE
/**********************************************************************/
/* ϥǡMPIб                                  */
/* mpi_InputStruct  O   MPIбη                                   */
/* ֤͡ 0: ｪλ                                               */
/**********************************************************************/
int Define_MPI_InputStruct(MPI_Datatype *mpi_inputStruct)
{
    int i = 0;

/* MPIط */
#define MAX_BLOCK_NUM 10    /* MPIѹ¤ΤȤηΥ֥å */

    int blockcount[MAX_BLOCK_NUM];
    MPI_Aint address[MAX_BLOCK_NUM];
    MPI_Datatype type[MAX_BLOCK_NUM];

    SnpData sti;  // Ȥʤ뷿ʹ¤Ρ

    /* MPIѤι¤Τѥ᡼ν */
    for (i = 0; i < MAX_BLOCK_NUM; i++) {
        blockcount[i] = 0;
        address[i] = (MPI_Aint)NULL;
        type[i] = MPI_INT;
    }

    /* ϥǡѤMPIѤι¤ */
    blockcount[0] = RS_NUM_LEN;
    blockcount[1] = SNP_NUM;
    blockcount[2] = CHROM_LEN;
    blockcount[3] = 1;
    blockcount[4] = 3 + SNP_COUNT;
    MPI_Address(sti.rsNumber, &address[0]);
    MPI_Address(sti.SNPalleles, &address[1]);
    MPI_Address(sti.chrom, &address[2]);
    MPI_Address(&sti.pos, &address[3]);
    MPI_Address(&sti.allelesNum, &address[4]);
    for (i = 4; i >= 0; i--) {
        address[i] -= address[0];
    }
    /*  */
    type[0] = MPI_CHAR;
    type[1] = MPI_CHAR;
    type[2] = MPI_CHAR;
    type[3] = MPI_LONG;
    type[4] = MPI_INT;
    MPI_Type_struct(5, blockcount, address, type, mpi_inputStruct);
    MPI_Type_commit(mpi_inputStruct);

#undef MAX_BLOCK_NUM

	return 0;
}

/* ǥХå */
void CheckCopySNPData(SnpData *snpData, long dataNum, int MyMpiRank, int IDNum)
{
    long i = 0, j = 0;
    static long len = 0;
    static char *buf = NULL;

    if (len < 22 + snpData[i].dataNum * 2 + 2) {
        len = 22 + snpData[i].dataNum * 2 + 2;
        if (buf != NULL)  free(buf);
        buf = (char*)malloc(sizeof(char) * len);
        for (i = 0; i < len; i++)  buf[i] = '\0';
    }

//    printf("SNP Data  rank  dNum\n");
    for (i = 0; i < dataNum; i++) {
        printf("%-4d  %-4d  %-6ld    ", IDNum, MyMpiRank, i); // 22ʸ
        for (j = 0; j < snpData[i].dataNum; j+=2) {
            printf("%c%c  ", snpData[i].SNPdata[j],
                             snpData[i].SNPdata[j+1]);
        }
        printf("\n");
    }

	return;
}
#endif /* MPI_USE */
