/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_TYPEI__
#define __HEADER_FILE_TYPEI__

#ifdef _MAIN_DEF
#define EXTERN
#else
#define EXTERN extern
#endif

#include "snp_Config.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"
#include "snp_GetTime.h"
#include "snp_Random.h"


/* ϥǡǼѹ¤ */
typedef struct struct_InputDataForTypeI {
    char inputFile1[MAX_LEN];   /* ϥե̾ */
    char inputFile2[MAX_LEN];   /* ϥե̾ */
    char outputFile1[MAX_LEN];  /* ϥե̾ */
    int areaFileType;           /* ΰեΥ */
    char blockAreaFile[MAX_LEN];/* haplotype֥åΰե̾ */
    int score;                  /* ׻ˡλ */
    long repeat;                /* ֤ */
    long gen;                   /* MCMC */
    int dataType;               /* ϥǡեޥåȤλ */
} InputTypeI;


/* MultiLocusԤ */
void MainProgramMulti(InputTypeI *inputTypeI);
/* ϥץ״ϢϤType I errorγΨ׻¹Ԥ */
int TypeIExecute(double *freq, char **haplotype, long L, double Sobs, long a, long b, long dataNum, double *typeIError, long repeat, long gen);
/* MCMC¹ */
void TypeIMarkov(int **X, double *h, long L);
/* ǽhaplotypeȤå */
int TypeIStartSet2(long sampleSize, long L, int *result);
/* ٤㤵ǽΥåȤ */
int TypeIStartSet(long sampleSize, double *frequency, long L, int *result);
/* ٤㤷֤ͤ */
long TypeIDiscreteRandomValue(double *xlist, long len);
/* Ψ1/201֤ */
int TypeIZeroOne();
/* ϥץפXɽƤ */
int TypeISampling(int *X, char **haplotype, long dataNum, long L, char **sequences);

EXTERN int MyMpiSize; /* MPIΥץ */
EXTERN int MyMpiRank; /* MPIμRank   */

#ifdef MPI_USE
#define NUM_TM   100
double tm[NUM_TM];  /* ַ¬ */
#define TM_START       0
#define TM_B_BCAST     1
#define TM_A_BCAST     2
#define TM_B_CALC      3
#define TM_A_CALC      4
#define TM_B_GATHER    5
#define TM_A_GATHER    6
#define TM_END         7
#define TM_B_READ      8
#define TM_A_READ      9
#define TM_B_WRITE    10
#define TM_A_WRITE    11
#define TM_B_F_BCAST  12
#define TM_A_F_BCAST  13
#define TM_B_F_GATHER 14
#define TM_A_F_GATHER 15
#endif /* MPI_USE */

#endif /* __HEADER_FILE_TYPEI__ */
