/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_DATA_READER__
#define __HEADER_FILE_DATA_READER__

#include "Config.h"

/* 入力データ格納用構造体 */
typedef struct struct_SNPData { 
	char rsNumber[RS_NUM_LEN];      /* rs# */
    char alleles[ALLELES_LEN];      /* alleles */
    char chrom[CHROM_LEN];          /* chrom */
    long pos;                       /* pos */
    char *SNPdata;                  /* SNPデータ格納用 */
    int sampleNum;                  /* サンプル人数 */
    int sampleDataNum;              /* サンプルデータ数 */
} SnpData;


/* プロトタイプ宣言 */
/* 入力ファイルを開く */
int InputFileOpen(FILE **fp, char *file);
/* 出力ファイルを開く */
int OutputFileOpen(FILE **fp, char *file);
/* ファイルを閉じる */
void FileClose(FILE *fp);

/* ファイルの行数をカウントする */
long DataReaderCountFileLine(FILE *fp);
/* 入力データを構造体に収める */
int DataReaderSetAllData(FILE *fp, SnpData *snpData, long line, int dataType);
/* 入力データ一行を構造体に収める */
int DataReaderSetData(FILE *fp, SnpData *snpData, long line, int dataType);
/* Hapmapデータを構造体に収める */
int DataReaderSetAllHapmapData(FILE *fp, SnpData *snpData, long line);
/* Hapmapデータ一行を構造体に収める */
int DataReaderSetHapmapData(FILE *fp, SnpData *snpData, long line);
/* phasingされたHapmapデータを構造体に収める */
int DataReaderSetAllPhasingHapmapData(FILE *fp, SnpData *snpData, long line);
/* phasingされたHapmapデータ一行を構造体に収める */
int DataReaderSetPhasingHapmapData(FILE *fp, SnpData *snpData, long line);
/* 構造体SnpDataメンバのメモリを確保する */
int DataReaderSnpDataMemoryAllocate(SnpData *snpData, long dataNum, long sampleNum);
/* 構造体SnpDataメンバのメモリを開放する */
int DataReaderSnpDataMemoryFree(SnpData *snpData, long dataNum);
/* LDブロック領域を配列に格納する */
int DataReaderSetLDBlock(FILE *fp, long *ldBlock);
/* 入力データのサンプルデータ数を取得する */
long DataReaderGetSampleDataNum(FILE *fp, int dataType);
/* HapmapDataのサンプルデータ数を取得する */
long DataReaderGetHapmapSampleDataNum(FILE *fp);
/* phasingされたHapmapデータのサンプルデータ数を取得する */
long DataReaderGetPhasingHapmapSampleDataNum(FILE *fp);

#endif /* __HEADER_FILE_DATA_READER__ */
