/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_CONFIG__
#define __HEADER_FILE_CONFIG__

//#define DBG
//#define Linux

int iWay;               /* スコア計算方法の指定 */
                        /* 0:ピアソンスコア　1:Fst */
long idum;              /* ランダム関数ran2()への入力値 */

enum { ROW = 2 };       /* 偶現表の行数 */
enum { COLUMN = 2 };    /* 偶現表の行数 */
enum { VAL = 2 };       /* 値指定用の定数 */

enum { CASE = 3 };      /* case人数 */
enum { CONTROL = 3 };   /* control人数 */

enum { FLAG_FALSE = 0,
       FLAG_TRUE = 1};

enum { WITH_IN_RANGE = 0,   /* l<=a1<=v or w<=a1<=u */
       OUT_OF_RANGE = 1,    /* a1<l or u<a1 */
       IN_BETWEEN = 2 };    /* v<a1<w */

/*　エラー時のステータス　*/
enum { NORMAL_STATUS = 0 };
enum { ERROR_MEMORY_ALLOC = 1000 };

/* Hapmapデータ読み込み時のパラメータ */
enum { HAPMAP_RS_NUM = 1 };    /* Hapmapデータのrs#列を示す */
enum { HAPMAP_ALLELES = 2 };   /* HapmapデータのSNPalleles列を示す */
enum { HAPMAP_CHROM = 3 };     /* Hapmapデータのchrom列を示す */
enum { HAPMAP_POS = 4 };       /* Hapmapデータのpos列を示す */
enum { HAPMAP_DATA = 12 };     /* Hapmapデータの遺伝子データ開始列 */

/* Haplotypeデータ読み込み時のパラメータ */
enum { HAPLOTYPE_RS_NUM = 1 };  /* HAPLOTYPEデータのrs#列を示す */
enum { HAPLOTYPE_ALLELES = 6 }; /* HAPLOTYPEデータのSNPalleles列を示す */
enum { HAPLOTYPE_CHROM = 3 };   /* HAPLOTYPEデータのchrom列を示す */
enum { HAPLOTYPE_POS = 5 };     /* HAPLOTYPEデータのpos列を示す */
enum { HAPLOTYPE_DATA = 7 };    /* HAPLOTYPEデータの遺伝子データ開始列 */

/* PhasingされたHapmapデータ読み込み時のパラメータ */
enum { PHASE_RS_NUM = 1 };     /* PhasingHapmapデータのrs#列を示す */
enum { PHASE_POS = 2 };        /* PhasingHapmapデータのpos列を示す */
enum { PHASE_DATA = 3 };       /* PhasingHapmapデータの遺伝子データ開始列 */

/* データ格納用構造体に用いるパラメータ */
enum { SNP_NUM = 3 };       /* SNPallelesのパターン数 */
enum { SNP_COUNT = 3 };     /* SNPallelesに合致するデータカウント用 */
enum { RS_NUM_LEN = 30};    /* rs#の文字数 */
enum { CHROM_LEN = 5};      /* chromの文字列 */
//enum { SNP_DATA_LEN = 1000};/* サンプデータ数　人数の２倍(500人) */

/* 入力データ読み込み時のパラメータ */
enum { MAX_LEN = 1024 };    /* 入力データファイルの一行の最大文字数 */
enum { PRINT_LEVEL = 0 };   /* プリントレベルのデフォルト値 */
enum { SCORE = 0 };         /* スコア計算方法のデフォルト値 */
enum { REPEAT = 1000 };     /* ループ回数のデフォルト値 */
enum { ANALYSIS = 0 };      /* 解析方法のデフォルト値 */
enum { DATA_TYPE = 0 };     /* 入力データフォーマットのデフォルト値 */

#endif /* __HEADER_FILE_CONFIG__ */
