/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_PRIMITIVE__
#define __HEADER_FILE_PRIMITIVE__

#include "snp_Config.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"
#include "snp_Permutation.h"
#include "snp_Random.h"


/* 入力データ格納用構造体 */
typedef struct struct_InputDataForPrimitive {
    char inputFile1[MAX_LEN];   /* 入力ファイル名 */
    char inputFile2[MAX_LEN];   /* 入力ファイル名 */
    char outputFile1[MAX_LEN];  /* 出力ファイル名 */
    int areaFileType;           /* 領域指定ファイルのタイプ */
    char blockAreaFile[MAX_LEN];/* haplotypeブロック領域指定ファイル名 */
    int score;                  /* スコア計算方法の指定 */
    long repeat;                /* 繰り返し回数 */
    int dataType;               /* 入力データフォーマットの指定 */
} InputPrimitive;


/* PrimitiveなPermutation検定を行う */
void MainProgramPrimitive(InputPrimitive *inputPrimitive);
/* PrimitiveなPermutation検定を実行する */
long PrimitiveExecute(SnpData *snpData1, SnpData *snpData2, double Sobs, long a, long b, long jStart, long jEnd, long repeat);

#endif /* __HEADER_FILE_PRIMITIVE__ */
