/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_RAT__
#define __HEADER_FILE_RAT__

#include "snp_Config.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"
#include "snp_Table.h"
#include "snp_Factorial.h"
#include "snp_Permutation.h"
#include "snp_Random.h"


/* 入力データ格納用構造体 */
typedef struct struct_InputDataForRAT {
    char inputFile1[MAX_LEN];   /* 入力ファイル名 */
    char inputFile2[MAX_LEN];   /* 入力ファイル名 */
    char outputFile1[MAX_LEN];  /* 出力ファイル名 */
    int areaFileType;           /* 領域指定ファイルのタイプ */
    char blockAreaFile[MAX_LEN];/* haplotypeブロック領域指定ファイル名 */
    int score;                  /* スコア計算方法の指定 */
    long gen;                   /* MCMC世代数 */
    long burnin;                /* 事前のMCMC回数 */
    int dataType;               /* 入力データフォーマットの指定 */
} InputRAT;


/* RATのPermutation検定を行う */
void MainProgramRAT(InputRAT *inputRAT, int nProc, int rank);
/* RATのPermutation検定を実行する */
double RATExecute(SnpData *snpData1, SnpData *snpData2, double Sobs, long a, long b, long jStart, long jEnd, long gen, long burnin);
/* マーカーjをnumberOfDiInHj[j]に比例した確率で返す */
long RATAlgorithmA(double *numberOfDiInHj, long m, dsfmt_t *snp_dsfmt_data);
/* 超幾何分布に従うMCMCで、以前のテープルから次のテープルを作成 */
int RATAlgorithmB(SnpTable T, double Score, int **table, dsfmt_t *snp_dsfmt_data);
/* 偶現表から１つのpermutation eventを等確率で抽出 */
int RATAlgorithmC(int *genotype, int **table, int *di,  dsfmt_t *snp_dsfmt_data);
/* Qの値を計算 */
long RATCalcQvalue(int **genotype, int *di, double Sobs, long n, long dataNum);
double RATNumberOfDiInHj(SnpTable table, double Sobs);
/* genotypeを計算 */
int RATGenotype(SnpData *snpData1, SnpData *snpData2, int *genotype);

#endif /* __HEADER_FILE_RAT__ */
