#!/bin/sh

if [ $# != 8 ];
  then 
    echo "[usage]`basename $0` [HapmapDataFile] [PhasedHapmapDataFile] [LDblockFile] [RecombinationFile] [ErrorRateFile] [OutputFile] [SamplePerDivision] [EstimateSampleNum]"
    exit
fi

HapmapDataFile=$1
PhasedHapmapDataFile=$2
LDblockFile=$3
RecombinationFile=$4
ErrorRateFile=$5
OutputFile=$6
SamplePerDivision=$7
EstimateSampleNum=$8

ScriptFile=`basename $OutputFile`.batch

### HapmapDataFile is not exist, exit
if [ ! -e "$HapmapDataFile" ];
  then
    echo "$HapmapDataFile is not exist"
    exit
fi
### PhasedHapmapDataFile is not exist, exit
if [ ! -e "$PhasedHapmapDataFile" ];
  then
    echo "$PhasedHapmapDataFile is not exist"
    exit
fi
### LDblockFile is not exist, exit
if [ ! -e "$LDblockFile" ];
  then
    echo "$LDblockFile is not exist"
    exit
fi
### RecombinationFile,ErrorRateFile is not exist, exit
if [ ! -e "$RecombinationFile" -a $EstimateSampleNum = 0 ];
  then
    echo "$RecombinationFile is not exist"
    exit
fi
if [ ! -e "$ErrorRateFile" -a $EstimateSampleNum = 0 ];
  then
    echo "$ErrorRateFile is not exist"
    exit
fi

### Make BatchScriptFile
echo "#!/bin/sh" > $ScriptFile
echo "" >> $ScriptFile
echo "#MJS: -mpc" >> $ScriptFile
echo "#MJS: -time 24:00:00" >> $ScriptFile
#echo "#MJS: -mem 4000mb" >> $ScriptFile
echo "#MJS: -cwd" >> $ScriptFile
echo "#MJS: -eo" >> $ScriptFile
echo "#MJS: -rerun y" >> $ScriptFile
echo "" >> $ScriptFile
echo "#BEFORE:MASTER: $HapmapDataFile" >> $ScriptFile
echo "#BEFORE:MASTER: $PhasedHapmapDataFile" >> $ScriptFile
echo "#BEFORE:MASTER: $LDblockFile" >> $ScriptFile
if [ $EstimateSampleNum = 0 ];
  then
    echo "#BEFORE:MASTER: $RecombinationFile" >> $ScriptFile
    echo "#BEFORE:MASTER: $ErrorRateFile" >> $ScriptFile
  else
    echo "#AFTER:MASTER: $RecombinationFile" >> $ScriptFile
    echo "#AFTER:MASTER: $ErrorRateFile" >> $ScriptFile
fi
echo "#AFTER:MASTER: $OutputFile" >> $ScriptFile
#echo "#BEFORE:*: ../bin/imputation.exe" >> $ScriptFile
#echo "#BEFORE:*: ../bin/mach1" >> $ScriptFile
echo "#BEFORE:*: $SNP_HOME/bin/imputation.exe" >> $ScriptFile
echo "#BEFORE:*: $SNP_HOME/bin/mach1" >> $ScriptFile
echo "" >> $ScriptFile
echo "cd \${MJS_CWD}" >> $ScriptFile
echo "srun imputation.exe $HapmapDataFile $PhasedHapmapDataFile $LDblockFile $RecombinationFile $ErrorRateFile $OutputFile $SamplePerDivision $EstimateSampleNum" >> $ScriptFile

### Execute Batch Job
qsub $ScriptFile

### Delete BatchScriptFile
rm $ScriptFile
