#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "snp_Config.h"
#include "snp_Permutation.h"
#include "snp_Factorial.h"
#include "snp_Q.h"
#include "snp_G.h"
#include "snp_Table.h"
#include "snp_Primitive.h"
#include "snp_MCMC.h"
#include "snp_Gsampler.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"
#include "snp_GetTime.h"
#include "snp_Chi.h"
#include "snp_TypeI.h"

int main(int argc, char* argv[])
{
    int num = 0;

    /**********************/
    /* svOI */
    /**********************/
    while(1){
        printf("\n");
        printf("(1)execute Gsampler\n");
        printf("(2)execute Permutation\n");
        printf("(3)execute Q\n");
        printf("(4)execute G\n");
        printf("(5)execute Table\n");
        printf("(6)execute MCMC\n");
        printf("(7)execute Primitive\n");
        printf("(8)execute Chi\n");
        printf("(9)execute TypeI\n");
        printf("(0)end\n");
        printf("select number --> ");
        scanf("%d", &num);

        switch(num){
            case 1:
                /* Gsampler eXg */
                GsamplerMain();
                break;
            case 2:
                /* Permutation eXg */
                PermutationMain();
                break;
            case 3:
                /* Q eXg */
                QMain();
                break;
            case 4:
                /* G eXg */
                GMain();
                break;
            case 5:
                /* Table eXg */
                TableMain();
                break;
            case 6:
                /* MCMC eXg */
                MCMCMain();
                break;
            case 7:
                /* Primitive eXg */
                PrimitiveMain();
                break;                      
            case 8:
                /* Chi eXg */
                ChiMain();
                break;
                      
            case 9:
                /* TypeI eXg */
                TypeIMain();
                break;
            case 0:
                exit(0);
            default:
                break;
        }
    }

    return 0;
}
