/*
 * Decompiled with CFR 0.152.
 */
package align;

import FFT.corr;
import format.fastaFormat;
import java.io.FileNotFoundException;
import java.io.IOException;
import sequence.nucleotide;
import sequence.sequenceBase;
import statistics.stas;
import test.RandomSequence;

class PAFFT {
    PAFFT() {
    }

    public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        double[][][] num = new double[2][][];
        String[][] reference = fastaFormat.input(args[0]);
        String[][] data = fastaFormat.input(args[1]);
        double significance = new Double(args[2]);
        double extention = new Double(args[3]);
        String refLong = RandomSequence.pacBioSequence(reference[1][0], extention, 0.41);
        num[0] = sequenceBase.numerize(refLong);
        stas s = new stas();
        int i = 0;
        while (i < data[1].length) {
            boolean isForward = true;
            num[1] = sequenceBase.numerize(data[1][i]);
            double[] score = corr.corrSqrt2(num[0], num[1]);
            int dataSize = score.length;
            double m = PAFFT.m(dataSize);
            double c = PAFFT.c(m);
            s.putArray(score);
            if (PAFFT.p_value(s.max(), m, c) < significance) {
                PAFFT.output(PAFFT.tabular(data[0][i], data[1][i], reference[0][0], reference[1][0], s.maxPos(), s.max(), PAFFT.p_value(s.max(), m, c), isForward));
            }
            isForward = false;
            num[1] = sequenceBase.numerize(nucleotide.reverseDNA(data[1][i]));
            score = corr.corrSqrt2(num[0], num[1]);
            s.putArray(score);
            if (PAFFT.p_value(s.max(), m, c) < significance) {
                PAFFT.output(PAFFT.tabular(data[0][i], data[1][i], reference[0][0], reference[1][0], s.maxPos(), s.max(), PAFFT.p_value(s.max(), m, c), isForward));
            }
            ++i;
        }
    }

    public static String[] tabular(String queryName, String query, String referenceName, String reference, double pos, double p, double score, boolean forward) {
        String[] result = new String[12];
        result[0] = queryName;
        result[1] = referenceName;
        result[2] = "0";
        result[3] = "0";
        result[4] = "0";
        result[5] = "0";
        if (forward) {
            result[6] = "1";
            result[7] = new Integer(query.length()).toString();
        } else {
            result[6] = new Integer(query.length()).toString();
            result[7] = "1";
        }
        result[8] = new Double(pos).toString();
        result[9] = new Double(pos + (double)query.length()).toString();
        result[10] = new Double(p).toString();
        result[11] = new Double(score).toString();
        return result;
    }

    public static void output(String[] result) {
        System.out.print(result[0]);
        int i = 1;
        while (i < result.length) {
            System.out.print("\t");
            System.out.print(result[i]);
            ++i;
        }
        System.out.println();
    }

    public double[] mOrg() {
        double[] result = new double[14];
        result[0] = 0.0;
        return result;
    }

    public static double p_value(double x, double m, double c) {
        return Math.exp(-(x - m) / c);
    }

    static double m(int n) {
        double mold = PAFFT.start(n);
        double mnew = 0.0;
        double logn = Math.log(n);
        int count = 0;
        while (count < 10) {
            mold = mnew = mold - (PAFFT.logOrg(mold) - logn) / PAFFT.d(mold);
            ++count;
        }
        return mold;
    }

    static double start(int n) {
        return Math.sqrt(2.0 * Math.log(n) - Math.log(Math.PI * 2));
    }

    static double org(double m) {
        return Math.exp(m * m / 2.0) * m * Math.sqrt(Math.PI * 2);
    }

    static double logOrg(double m) {
        return m * m / 2.0 + Math.log(m) + Math.log(Math.PI * 2) / 2.0;
    }

    static double d(double m) {
        return m + 1.0 / m;
    }

    static double c(int n) {
        return PAFFT.c(PAFFT.m(n));
    }

    static double c(double m) {
        return m / (m * m + 1.0);
    }
}

