/*
 * Decompiled with CFR 0.152.
 */
package paraselene.dyna;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import paraselene.dyna.DynamicPage;
import paraselene.dyna.SaxContainer;
import paraselene.mockup.Linker;
import paraselene.tag.attr.Attribute;

class CallBack
extends HTMLEditorKit.ParserCallback {
    private SaxContainer sax;
    private boolean script_end = false;
    private static final String[] endtag_list = new String[]{"iframe", "embed"};

    CallBack(DynamicPage p) {
        this.sax = new SaxContainer(p);
    }

    @Override
    public void handleError(String errorMsg, int pos) {
    }

    @Override
    public void handleComment(char[] data, int pos) {
        this.script_end = false;
        this.sax.addComment(data);
    }

    @Override
    public void handleText(char[] data, int pos) {
        if (this.script_end) {
            String txt = new String(new char[]{data[0]});
            Linker.readme.addNote("script\u30bf\u30b0\u76f4\u5f8c\u306e\u30c6\u30ad\u30b9\u30c8\u304b\u3089\"" + txt + "\"\u3092\u9664\u5916\u3057\u307e\u3057\u305f\u3002");
            char[] tmp = new char[data.length - 1];
            for (int i = 1; i < data.length; ++i) {
                tmp[i - 1] = data[i];
            }
            data = tmp;
        }
        this.script_end = false;
        this.sax.addText(data, false);
    }

    private ArrayList<Attribute> getAttr(MutableAttributeSet a) {
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        Enumeration<?> em = a.getAttributeNames();
        while (em.hasMoreElements()) {
            Object key = em.nextElement();
            Object val = a.getAttribute(key);
            Attribute attr = val == null ? new Attribute(key.toString()) : new Attribute(key.toString(), val.toString());
            ret.add(attr);
        }
        return ret;
    }

    private boolean isEndTagFix(String tag) {
        for (int i = 0; i < endtag_list.length; ++i) {
            if (!endtag_list[i].equalsIgnoreCase(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        this.script_end = false;
        String tag_name = t.toString();
        try {
            if (this.isEndTagFix(tag_name)) {
                ArrayList<Attribute> list = this.getAttr(a);
                int cnt = list.size();
                for (int i = 0; i < cnt; ++i) {
                    Attribute attr = list.get(i);
                    if (!attr.getName().equals("endtag") || !attr.getString().equals("true")) continue;
                    this.handleEndTag(t, pos);
                    return;
                }
                this.handleStartTag(t, a, pos);
                return;
            }
            this.sax.addTag(tag_name, this.getAttr(a));
            this.sax.endTag();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        this.script_end = false;
        try {
            this.sax.addTag(t.toString(), this.getAttr(a));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        this.sax.endTag();
        this.script_end = "script".equalsIgnoreCase(t.toString());
    }
}

