/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;


import java.util.*;

/**
 * タイムアウトによる強制停止発生。<BR>
 * Pageインスタンスのinput()またはoutput()は規定時間(デフォルト3分)リターン
 * しなかった場合、タイムアウトにより強制停止させられます。
 * その際に発生する例外です。<BR>
 * この例外が発生する場合、システム設計の見直しを推奨します。<BR><BR>
 * synchronized中で同期処理を行っている箇所があり、そこで強制停止した場合、
 * 同期を取ろうとしているオブジェクトの更新が不完全で、データ不整合を起こす
 * 可能性があります。<BR>
 * また、クローズしていないリソースが残存する可能性もあります。<BR>
 * そのため、この例外が発生した場合は、サーブレットコンテナの再起動を推奨します。
 */
public class KilledByTimeoutException extends Exception {
	private static final long serialVersionUID = 1L;
	ArrayList<StackTraceElement[]>	snap;
	KilledByTimeoutException( StackTraceElement[] one, ArrayList<StackTraceElement[]> all ){
		super();
		setStackTrace( one );
		snap = all;
	}

	public String toString() {
		StringBuilder	buf = new StringBuilder( super.toString() );
		int	cnt = snap.size();
		for ( int i = 0; i < cnt; i++ ) {
			buf = buf.append( "\n=====[job " );
			buf = buf.append( i );
			buf = buf.append( "]=======================================\n" );
			StackTraceElement[]	s = snap.get( i );
			for ( int j = 0; j < s.length; j++ ) {
				buf = buf.append( s[j].toString() );
				buf = buf.append( "\n" );
			}
			buf = buf.append( "=====\n" );
		}
		return buf.toString();
	}
}

