/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.table;


import java.io.*;
import paraselene.*;
import paraselene.tag.*;

/**
 * カラムを表す。tdタグまたはthタグ。
 * スレッドセーフです。
 */
public class Column extends Tag {
	private static final long serialVersionUID = 1L;
	/**
	 * タイプ。
	 */
	public enum Type {
		/**
		 * テーブルヘッダ。THタグ。
		 */
		HEADER("th"),
		/**
		 * テーブルデータ。TDタグ。
		 */
		DATA("td");

		private static final long serialVersionUID = 1L;
		String str;

		private Type( String s ) {
			str = s;
		}
	}

	private static final Text	spc = new Text( " " );
	private Type	const_type;
	/**
	 * 種別の取得。
	 * @return 種別。
	 */
	public Type getType() {
		return const_type;
	}

	/**
	 * コンストラクタ。
	 * @param type タイプ。
	 */
	public Column( Type type ) {
		super( type.str, false );
		const_type = type;
	}

	protected Tag newReplica() {
		return new Column( const_type );
	}

	/**
	 * 出力。タグ内部が空文字列であれば、半角スペースに置換する。
	 * @param w ライター。
	 * @param mode 文字列種別。
	 */
	public synchronized void write( PrintWriter w, StringMode mode ) {
		w.print( getFirstTag() );
		int cnt = getHTMLPartCount();
		mode = StringMode.TABLE;
		boolean	out_f = false;
		for ( int i = 0; i < cnt; i++ ) {
			HTMLPart	p = getHTMLPart( i );
			p.write( w, mode );
			if ( p instanceof Text ) {
				String	data = p.toString( StringMode.PLAIN );
				if ( data != null ) {
					if ( !data.isEmpty() )	out_f = true;
				}
			}
			else if ( p instanceof Tag )	out_f = true;
		}
		if ( !out_f ) {
			spc.write( w, mode );
		}
		w.print( getLastTag() );
	}
}

