/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import paraselene.Text;
import paraselene.supervisor.DebugEcho;
import paraselene.supervisor.PageFactory;

public class Option
implements Serializable {
    public String now = new Text(new Date(), "yyyy/MM/dd HH:mm:ss").toString();
    public String[] message;
    public String[] stack;
    private static final String MYSELF = "paraselene.supervisor.Option";
    private static volatile boolean debug_f = false;
    private static ArrayList<PageFactory> factory = new ArrayList();
    private static HashMap<String, HashMap<String, DebugEcho>> echo = new HashMap();

    Option(String mes, StackTraceElement[] ste) {
        String name;
        int start;
        this.message = mes.split("[\n\r]");
        ArrayList<String> list = new ArrayList<String>();
        boolean flag = false;
        for (start = 0; start < ste.length; ++start) {
            name = ste[start].getClassName();
            if (!MYSELF.equals(name) && !"paraselene.supervisor.DebugEcho".equals(name)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            start = 0;
        }
        while (start < ste.length && (MYSELF.equals(name = ste[start].getClassName()) || "paraselene.supervisor.DebugEcho".equals(name))) {
            ++start;
        }
        while (start < ste.length) {
            list.add(ste[start].toString());
            ++start;
        }
        this.stack = list.toArray(new String[0]);
    }

    public static void setDebugMode() {
        debug_f = true;
    }

    public static void setReleaseMode() {
        debug_f = false;
    }

    public static boolean isReleaseMode() {
        return !debug_f;
    }

    static void entry(PageFactory pf) {
        String cls = pf.getClass().getName();
        int cnt = factory.size();
        for (int i = 0; i < cnt; ++i) {
            if (!factory.get(i).getClass().getName().equals(cls)) continue;
            Option.factory.remove((int)i).running_f = false;
            break;
        }
        factory.add(pf);
    }

    public static PageFactory.Information[] getPageFactoryInformation() {
        int cnt = factory.size();
        PageFactory.Information[] info = new PageFactory.Information[cnt];
        for (int i = 0; i < cnt; ++i) {
            info[i] = factory.get(i).getInformation();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entryDebug(String name, HttpSession session, String key) {
        HashMap<String, HashMap<String, DebugEcho>> hashMap = echo;
        synchronized (hashMap) {
            HashMap<String, DebugEcho> map = echo.get(name);
            if (map == null) {
                map = new HashMap();
                echo.put(name, map);
            }
            new DebugEcho(session, key, map);
        }
    }

    public static void removeDebug(HttpSession session, String key) {
        DebugEcho.removeSession(session, key);
    }

    public static void debug(String format, Object ... param) {
        if (Option.isReleaseMode()) {
            return;
        }
        Option.debug(String.format(format, param), Thread.currentThread().getStackTrace());
    }

    public static void debug(Throwable e) {
        if (Option.isReleaseMode()) {
            return;
        }
        Option.debug(e.toString(), e.getStackTrace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debug(String mes, StackTraceElement[] sta) {
        HashMap<String, HashMap<String, DebugEcho>> hashMap = echo;
        synchronized (hashMap) {
            for (String k : echo.keySet()) {
                HashMap<String, DebugEcho> map;
                boolean call = false;
                int k_len = k.length();
                for (int i = 0; i < sta.length; ++i) {
                    String cmp = sta[i].getClassName();
                    if (cmp.length() > k_len) {
                        cmp = cmp.substring(0, k_len);
                    }
                    if (!k.equals(cmp)) continue;
                    call = true;
                    break;
                }
                if (!call || (map = echo.get(k)) == null) continue;
                for (String k2 : map.keySet()) {
                    DebugEcho de = map.get(k2);
                    de.echo(mes, sta);
                }
            }
        }
    }
}

