/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.net.*;
import java.io.*;

/**
 * テキスト。出力時に一切テキストの加工を行いません。<br>
 * 入力値をタグとして認識させたい場合などの特殊な用途で使用できます。
 * スレッドセーフです。
 */
public class PlainText extends HTMLPart {
	private static final long serialVersionUID = 2L;
	private String	text;

	protected PlainText() {}

	/**
	 * コンストラクタ。StringMode.PLAIN扱い。
	 * @param txt テキスト。
	 */
	public PlainText( String txt ) {
		setText( txt );
	}

	/**
	 * 文字列の設定。
	 * @param txt テキスト。
	 */
	protected void setText( String txt ) {
		text = txt;
	}

	/**
	 * テキスト化。
	 * @param mode 出力モード。無視されます。
	 * @return 文字列。
	 */
	public String toString( StringMode mode ) {
		return text;
	}

	public HTMLPart getReplica() {
		return new PlainText( toString( StringMode.PLAIN ) );
	}

	/**
	 * 複製の作成。getReplica()の戻り値をキャストして返します。
	 * @return 複製。
	 */
	public Valuable getValuableReplica() {
		return (Valuable)getReplica();
	}
}


