/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.dyna;

import java.util.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import paraselene.tag.*;
import paraselene.tag.attr.*;
import paraselene.mockup.*;

class Handler extends DefaultHandler {
	private SaxContainer	sax;

	public void warning( SAXParseException e ) throws SAXException {
		Linker.readme.echoln( String.format( "WARNING: line %d =>  %s", e.getLineNumber(), e.getMessage() ) );
	}

	public void error( SAXParseException e ) throws SAXException {
		Linker.readme.echoln( String.format( "NEGLIGIBLE ERROR: line %d =>  %s", e.getLineNumber(), e.getMessage() ) );
	}

	public void fatalError( SAXParseException e ) throws SAXException {
		Linker.readme.echoln( String.format( "FATAL ERROR: line %d =>  %s", e.getLineNumber(), e.getMessage() ) );
		if ( Linker.flag )	System.exit( 1 );
		throw new SAXException( e );
	}


	Handler( DynamicPage p ) {
		sax = new SaxContainer( p );
	}

	public void characters( char[] ch, int start, int length ) throws SAXException {
		sax.addText( ch, start, length, true );
	}

	public void startElement( String uri, String localName, String qName, Attributes attributes ) throws SAXException {
		ArrayList<Attribute>	a = new ArrayList<Attribute>();
		int	cnt = attributes.getLength();
		for ( int i = 0; i < cnt; i++ ) {
			a.add( new Attribute( attributes.getQName( i ), attributes.getValue( i ) ) );
		}
		try {
			sax.addTag( qName, a );
		}
		catch( Exception e ) {
			throw new SAXException( e );
		}
	}

	public void endElement( String uri, String localName, String qName ) throws SAXException {
		sax.endTag();
	}
}

