/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.table;

import java.util.ArrayList;
import paraselene.HTMLPart;
import paraselene.tag.Tag;
import paraselene.tag.table.Column;

public class Line
extends Tag {
    private static final long serialVersionUID = 2L;

    public Line() {
        super("tr", false);
    }

    @Override
    protected Tag newReplica() {
        return new Line();
    }

    public Column[] getColumnArray() {
        Tag[] tag = this.getTagArray();
        ArrayList<Column> clm = new ArrayList<Column>();
        for (int i = 0; i < tag.length; ++i) {
            if (!(tag[i] instanceof Column)) continue;
            clm.add((Column)tag[i]);
        }
        return clm.toArray(new Column[0]);
    }

    public void addColumn(Column column) {
        this.addHTMLPart((HTMLPart)column);
    }

    public void addColumn(int idx, Column column) {
        Column[] clm = this.getColumnArray();
        if (clm.length <= idx) {
            this.addHTMLPart((HTMLPart)column);
            return;
        }
        this.addHTMLPart(this.indexOf(clm[idx]), (HTMLPart)column);
    }

    public synchronized void setValueString(int start, String ... str) {
        if (str == null) {
            return;
        }
        Column[] clm = this.getColumnArray();
        for (int i = 0; i + start < clm.length && i < str.length; ++i) {
            clm[i + start].setValueString(str[i]);
        }
    }

    public int indexOfColumn(Column column) {
        Column[] clm = this.getColumnArray();
        for (int i = 0; i < clm.length; ++i) {
            if (clm[i] != column) continue;
            return i;
        }
        return -1;
    }

    public void removeColumn(int idx) {
        Column[] clm = this.getColumnArray();
        if (clm.length <= idx) {
            return;
        }
        this.removeHTMLPart(clm[idx]);
    }

    public void removeColumn(Column column) {
        this.removeHTMLPart(column);
    }

    public void clearColumnInner() {
        this.clearColumnInner(0, Integer.MAX_VALUE);
    }

    public synchronized void clearColumnInner(int start, int count) {
        Column[] clm = this.getColumnArray();
        if ((count += start) > clm.length) {
            count = clm.length;
        }
        if (start < 0) {
            start = 0;
        }
        while (start < count) {
            clm[start].removeHTMLPart();
            ++start;
        }
    }
}

