// Paraselene generated this source file.
package #1;


import #1.#x.*;
import paraselene.*;
import paraselene.supervisor.*;

/**
 * サイトの呼び出しコントローラー。
 * 唯一のサーブレットです。
 * セキュリティ上問題になるので、このクラスでインスタンス変数の使用は
 * 避けて下さい。
 *
 * ファイルアップロード機能を使う場合は、
 * extends Supervisor
 * ではなく
 * extends UploadableSupervisor
 * として下さい。
 */
public class Gate extends Supervisor {
	private static final long serialVersionUID = 1L;

	static {
		startup();
	}

	/**
	 * コンストラクタ。
	 */
	public Gate() {
		super();
	}

	/**
	 * サーバー起動時の初期化処理。
	 */
	public static void startup() {
		// ページインスタンスはそれぞれ5を下回ると、2個ずつ補充される
		// 指定です。実際のアクセスに先行してページインスタンスは
		// 予めプールされ待機しています。
		// サイトへのユーザーアクセス規模に応じてパラメーターを変更して
		// 下さい。
		PageLoader.init( 5, 2 );

		// PageLoaderのinit()の直後に、PageTypeのinit()を必ずコールして
		// 下さい。
		PageType.init();
	}

	/**
	 * ページファクトリーの取得。
	 * @return ページファクトリー。
	 */
	public PageFactory getPageFactory() {
		// このメソッドの内容は変更しないで下さい。
		return PageLoader.getPageFactory();
	}

	/**
	 * エラー発生通知。
	 * @param e 発生例外。
	 */
	public void onError( Throwable e ) {
		// 必要であれば例外のロギング等を行って下さい。
		// リクエスト処理中に例外が発生すると必ず呼ばれます。
		// このメソッドからリターンした後、ブラウザにはステータス500を
		// 返します。
	}

	/**
	 * 不正呼び出しの検出通知。
	 * @param ir 検出内容。
	 * @param req リクエスト。
	 * @param from 遷移元ページ。
	 * @param to 遷移先ページ。
	 * @return 処理の変更指示。nullなら、通常通りに動作します。
	 */
	public Forward onIllegalRequest( IllegalRequest ir, RequestParameter req, Page from, Page to ){
		// nullを返せば、通常と同じ処理がなされます。
		// fromやtoの内容により、処理の中断が必要であれば、null以外の
		// 遷移先を返して下さい。
		// 遷移先ページを指定すると、input()は呼ばれず、output()を
		// コールします。
		return null;
	}

	/**
	 * 接続制限数を返す。
	 * @return 0以下なら無制限。1以上なら制限する。
	 */
	public int getRequestMaxCount() {
		// 同時リクエスト数を制限する場合は、0より大きな値を返して下さい。
		// 同時接続数がそれを超過するとステータス503を返します。
		return 0;
	}
}

