/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.css;

import java.util.*;
import java.io.*;


/**
 * セレクタの属性指定。
 */
public class SelectorAttribute implements Serializable {
	private static final long serialVersionUID = 2L;
	String	name;
	String	value;
	boolean include_f;
	boolean part_f;

	/**
	 * コンストラクタ。
	 * @param n 属性名。
	 * @param v 属性値。
	 * @param inc 内包選択ならtrue。
	 * @param part ハイフン選択ならtrue。
	 */
	public SelectorAttribute( String n, String v, boolean inc, boolean part ) {
		name = n.toLowerCase( Locale.ENGLISH ).trim();
		if ( v != null ) {
			value = v.trim();
		}
		include_f = inc;
		part_f = part;
	}

	/**
	 * 文字列化。
	 * @return 文字列。
	 */
	public String toString() {
		if ( "id".equals( name ) || "class".equals( name ) )	return "";
		StringBuilder	buf = new StringBuilder( "[" );
		buf = buf.append( CSSParser.escape( name ) );
		if ( value != null ) {
			if ( include_f )	buf = buf.append( "~" );
			else if ( part_f )	buf = buf.append( "|" );
			buf = buf.append( "=" );
			buf = buf.append( CSSParser.escape( value ) );
		}
		return buf.append( "]" ).toString();
	}
}

