/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup;


import java.util.*;


class JavaDefine {
	private static final String[]	def = new String[] {
		"abstract", "boolean", "break", "byte", "cast", "catch", "char", "class",
		"const", "continue", "default", "do", "double", "else", "extends", "final",
		"false", "finally", "float", "for", "goto", "if", "implements", "import",
		"instanceof", "int", "interface", "long", "native", "new", "package",
		"private", "protected", "public", "return", "short", "static", "super",
		"switch", "synchronized", "this", "throw", "throws", "transient", "true",
		"try", "void", "vlatile", "while"
	};

	private static HashMap<String, String>	map = new HashMap<String, String>();

	static {
		for ( int i = 0; i < def.length; i++ ) {
			map.put( def[i], def[i] );
		}
	}

	static boolean isDefine( String str, boolean part_ck ) {
		char[]	ch = str.toCharArray();
		if ( !Character.isJavaIdentifierStart( ch[0] ) )	return true;
		if ( part_ck ) {
			for ( int j = 1; j < ch.length; j++ ) {
				if ( !Character.isJavaIdentifierPart( ch[j] ) )	return true;
			}
		}
		return	map.get( str ) != null;
	}
}


