/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import java.util.*;
import java.io.*;
import paraselene.*;
import paraselene.ajax.*;
import paraselene.ajax.data.*;


class OutputCall {
	int next_key;
	Page last_page, next_page;
	RequestParameter	req;
	SessionData	data;
	Page[]	out = null;
	Forward forward;

	Page[] getPage() {
		return out;
	}

	OutputCall( int nk, Page lp, Forward fw, RequestParameter r, SessionData sd ) {
		next_key = nk;
		last_page = lp;
		next_page = fw.getPage( lp );
		forward = fw;
		req = r;
		data = sd;
	}

	void call() throws Throwable {
		next_page.setHistoryKey( next_key );
		PageID	last_id = null;
		if ( last_page instanceof NullPage ) {
			last_page = null;
		}
		if ( last_page != null ) {
			last_id = last_page.getID();
		}
		if ( data == null )	return;
		if ( forward.history_f ) {
			if ( next_page.getID() == last_id ) {
				last_id.getPageFactory().returnPage( next_page );
				next_page = last_page;
			}
			else if ( next_page.isAllowHistoryAdd() ) {
				Page	sub = data.hist.get( next_key ).getPage( next_page.getID() );
				if ( sub != null ) {
					next_page.getID().getPageFactory().returnPage( next_page );
					next_page = sub;
				}
			}
		}
		next_page.setRequestParameter( req );
		Option.trace( "%s/%s output(%s) call", next_page.getID(), next_page.getUniqueKey(), (last_page == null)?	"null": last_page.getID() );
		Page	view = SandBox.output( next_page, last_page, req );
		if ( view == null )	view = next_page;
		next_page.setInitialized( false );
		next_page.setRequestParameter( null );
		out = new Page[]{ next_page, view };
	}

	PostBack[] make() throws Exception {
		data.hist.get( next_key ).add( next_page );
		TagData[]	data = TagData.getTag( out[1] );
		PostBack[]	ret = new PostBack[data.length];
		for ( int i = 0; i < ret.length; i++ ) {
			ret[i] = new PostBack( data[i] );
		}
		Option.trace( "%s/%s to TagData JSON", next_page.getID(), next_page.getUniqueKey() );
		return ret;
	}
}

class OpenOutput extends OutputCall {
	OpenOutput( int nk, Page lp, Forward fw, Popup.Type type, RequestParameter r, SessionData sd ) {
		super( nk, lp, fw, r, sd );
		next_page.setPopupType( type );
	}

	void call() throws Throwable {
		Popup	p = (Popup)forward;
		if ( p.active_page != null )	return;
		super.call();
	}

	PostBack[] make() throws Exception {
		Popup	p = (Popup)forward;
		if ( p.active_page == null ) {
			data.hist.get( next_key ).add( next_page );
			Option.trace( "%s/%s to Popup open JSON", next_page.getID(), next_page.getUniqueKey() );
			return new PostBack[] { new PostBack( new Open( out[1], false ) ) };
		}
		if ( p.active_page.getPopupType() != Popup.Type.MODELESS )	return new PostBack[0];
		try {
			Page[]	page = data.hist.get( next_key ).getBrowsingPage();
			for ( int i = 0; i < page.length; i++ ) {
				if ( page[i].getPopupType() == Popup.Type.MODAL ) {
					Option.trace( "%s/%s to Popup active cancel, because MODAL opened", next_page.getID(), next_page.getUniqueKey() );
					return new PostBack[0];
				}
			}
		}
		finally {
			data.hist.get( next_key ).unlock();
		}
		Option.trace( "%s/%s to Popup active JSON", next_page.getID(), next_page.getUniqueKey() );
		return new PostBack[] { new PostBack( new Open( p.active_page, true ) ) };
	}
}

class CloseOutput extends OutputCall {
	CloseOutput( int nk, Page lp, Forward fw, RequestParameter r, SessionData sd ) {
		super( nk, lp, fw, r, sd );
	}

	void call() throws Throwable {}

	PostBack[] make() throws Exception {
		Closure	c = (Closure)forward;
		data.hist.get( next_key ).removePopup( c.close_page );
		Option.trace( "%s/%s to Popup close JSON", next_page.getID(), next_page.getUniqueKey() );
		return new PostBack[] { new PostBack( new Close( c.close_page ) ) };
	}
}

class LocationOutput extends OutputCall {
	LocationOutput( int nk, Page lp, Forward fw, RequestParameter r, SessionData sd ) {
		super( nk, lp, fw, r, sd );
	}

	void call() throws Throwable {
		if ( !forward.isLeave() )	super.call();
	}

	PostBack[] make() throws Exception {
		data.hist.get( next_key ).add( next_page );
		Forward	fw = forward;
		if ( !forward.isLeave() ) {
			fw = data.redirect( out, forward, req );
		}
		String	url = Supervisor.makeWithSessionURI( fw.getRedirectURI().toString(), null, null );
		Option.trace( "%s redirect JSON", url );
		return new PostBack[] { new PostBack( url ) };
	}
}

class OutputHolder {
	private Forward[]		forward = null;
	private OutputCall[]	opc = null;

	OutputHolder( int nk, Page lp, Forward fw, RequestParameter r, SessionData sd ) {
		Option.trace( "%s ajax %s", lp.getID(), lp.isAjax() );
		AjaxForward[]	af = fw.getAjaxForward( lp.isAjax() );
		if ( af != null ) {
			forward = new Forward[af.length];
			for ( int i = 0; i < af.length; i++ ) {
				forward[i] = (Forward)af[i];
			}
			opc = new OutputCall[af.length];
		}
		else {
			forward = new Forward[] { fw };
			opc = new OutputCall[1];
		}
		if ( lp.isAjax() ) {
			for ( int i = 0; i < forward.length; i++ ) {
				if ( forward[i] instanceof Closure ) {
					Closure	c = (Closure)forward[i];
					if ( c.close_page.getPopupType() == null ) {
						Option.trace( "new LocationOutput <- %s", forward[i] );
						opc[i] = new LocationOutput( nk, lp, forward[i], r, sd );
					}
					else {
						Option.trace( "new CloseOutput <- %s", forward[i] );
						opc[i] = new CloseOutput( nk, lp, forward[i], r, sd );
					}
				}
				else if ( forward[i] instanceof Feedback ) {
					Option.trace( "new OutputCall <- %s", forward[i] );
					opc[i] = new OutputCall( nk, lp, forward[i], r, sd );
				}
				else if ( forward[i] instanceof Popup ) {
					Option.trace( "new OpenOutput <- %s", forward[i] );
					Popup	p = (Popup)forward[i];
					opc[i] = new OpenOutput( nk, lp, forward[i], p.getType(), r, sd );
				}
				else {
					Option.trace( "new LocationOutput <- %s", forward[i] );
					opc[i] = new LocationOutput( nk, lp, forward[i], r, sd );
				}
			}
			return;
		}
		Option.trace( "new OutputCall <- %s", fw );
		opc[0] = new OutputCall( nk, lp, fw, r, sd );
	}

	void call() throws Throwable {
		for ( int i = 0; i < opc.length; i++ ) {
			opc[i].call();
		}
	}

	Page[] getPage() {
		Page[]	p = opc[0].getPage();
		return p;
	}

	Serializable[] getPostBack() throws Exception {
		ArrayList<Serializable>	ret = new ArrayList<Serializable>();
		for ( int i = 0; i < opc.length; i++ ) {
			PostBack[]	pb = opc[i].make();
			for ( int j = 0; j < pb.length; j++ ) {
				ret.add( pb[j] );
			}
		}
		return ret.toArray( new Serializable[0] );
	}
}

