/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import paraselene.*;

/**
 * 遷移先指定。output するページをポップアップ表示します。<br>
 * ただし、遷移元ページのgetAjaxSupportが有効でない場合は、通常の Forward と等価です。
 */
public class Popup extends Forward implements AjaxForward {
	private static final long serialVersionUID = 2L;
	Page active_page = null;
	/**
	 * ポップアップ種別。
	 */
	public enum Type {
		/**
		 * ポップアップの下のページのUI操作を許す。
		 */
		MODELESS,
		/**
		 * ポップアップの下のページのUI操作を禁止する。
		 */
		MODAL
	}

	private Type type;

	/**
	 * コンストラクタ。
	 * @param id 指定ページのポップアップ。
	 * @param dialog_type ポップアップ種別。
	 */
	public Popup( PageID id, Type dialog_type ) {
		super( id );
		type = dialog_type;
	}

	/**
	 * コンストラクタ。
	 * 指定ページの Z順を手前にします。
	 * @param page MODELESSのポップアップ。
	 */
	public Popup( Page page ) {
		this( page.getID(), Type.MODELESS );
		active_page = page;
	}

	void overwriteType( Type t ) {
		if ( t == Type.MODELESS )	return;
		type = t;
	}

	Type getType() {
		return type;
	}

	/**
	 * 同じ動作であるか？
	 * 常にfalseを返します。
	 * @param o 比較対象。
	 * @return true:同一動作、false:異なる動作。
	 */
	public boolean equals( Object o ) {
		return false;
	}

	public String toString() {
		StringBuilder	buf = new StringBuilder( "Popup " );
		if ( active_page != null ) {
			buf = buf.append( "active:" );
			buf = buf.append( active_page.getID().toString() );
			buf = buf.append( "/" ).append( active_page.getUniqueKey() );
		}
		else {
			buf = buf.append( "open:" );
			buf = buf.append( getPageID().toString() );
			buf = buf.append( "/" ).append( type.toString() );
		}
		return buf.toString();
	}
}

