/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import paraselene.HTMLPart;
import paraselene.NumberValue;
import paraselene.PlainText;
import paraselene.WebColor;
import paraselene.css.CSSValuable;
import paraselene.tag.AttributeValuable;

public class Color
extends PlainText
implements AttributeValuable,
CSSValuable {
    private static final long serialVersionUID = 2L;
    private int red = -1;
    private int green = -1;
    private int blue = -1;

    @Override
    public HTMLPart getReplica() {
        return new Color(this.red, this.green, this.blue);
    }

    public Color(String s) {
        this.setText(s);
    }

    private int toRGB(NumberValue num) {
        int v;
        if (num.getUnit() == NumberValue.Unit.PERCENTAGE) {
            num.multiply(256).divide(100);
        }
        if ((v = num.toInteger()) > 256) {
            v = 255;
        }
        return v;
    }

    private boolean set_rgb_text(String str) {
        String[] all = str.split("[\\(\\)]");
        if (all.length != 2) {
            return false;
        }
        if (!"rgb".equalsIgnoreCase(all[0].trim())) {
            return false;
        }
        String[] rgb = all[1].split(",");
        if (rgb.length != 3) {
            return false;
        }
        NumberValue[] num = new NumberValue[3];
        for (int i = 0; i < 3; ++i) {
            num[i] = new NumberValue(rgb[i]);
        }
        this.setColor(this.toRGB(num[0]), this.toRGB(num[1]), this.toRGB(num[2]));
        return true;
    }

    @Override
    public void setText(String s) {
        if (s == null) {
            super.setText(s);
            return;
        }
        if ((s = s.trim()).isEmpty()) {
            super.setText(s);
            return;
        }
        if (this.set_rgb_text(s)) {
            return;
        }
        if (s.charAt(0) != '#') {
            this.setColor(WebColor.valueOf(s.toUpperCase()));
            return;
        }
        char[] ch = s.substring(1).toCharArray();
        int[] rgb = new int[3];
        if (ch.length == 3) {
            for (int i = 0; i < 3; ++i) {
                StringBuilder buf = new StringBuilder(ch[i]);
                buf = buf.append(ch[i]);
                rgb[i] = Integer.parseInt(buf.toString(), 16);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                rgb[i] = Integer.parseInt(new String(ch, i * 2, 2), 16);
            }
        }
        this.setColor(rgb[0], rgb[1], rgb[2]);
    }

    public Color(WebColor wc) {
        this.setColor(wc);
    }

    public void setColor(WebColor wc) {
        this.setColor(wc.red, wc.green, wc.blue);
    }

    public Color(int r, int g, int b) {
        this.setColor(r, g, b);
    }

    public void setColor(int r, int g, int b) {
        if (r < 0 || g < 0 || b < 0) {
            this.blue = -1;
            this.green = -1;
            this.red = -1;
            super.setText("transparent");
        } else {
            this.red = r & 0xFF;
            this.green = g & 0xFF;
            this.blue = b & 0xFF;
            super.setText(String.format("#%06X", this.red << 16 | this.green << 8 | this.blue));
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }
}

