/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import paraselene.Page;
import paraselene.URIValue;
import paraselene.supervisor.DataHolder;
import paraselene.supervisor.Forward;
import paraselene.supervisor.HistorySet;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RedirectData;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.Supervisor;
import paraselene.supervisor.TransactionSequencer;

class SessionData
implements Serializable,
HttpSessionBindingListener {
    private static final long serialVersionUID = 2L;
    TransactionSequencer seq = new TransactionSequencer();
    HistorySet hist = null;
    private HashMap<PageID, RedirectData> pending = new HashMap();
    private volatile int client;
    boolean planed_clear = false;

    private int getClient(HttpServletRequest req) {
        String[] data = new String[]{req.getHeader("User-Agent"), req.getHeader("HTTP-Client-IP"), req.getHeader("X-Forwarded-For"), req.getHeader("Remote-Addr")};
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) {
                data[i] = "non";
            }
            buf = buf.append("*");
            buf = buf.append(data[i]);
        }
        return buf.toString().hashCode();
    }

    SessionData(HttpServletRequest req) {
        this.client = this.getClient(req);
        this.hist = new HistorySet(req.getSession().getId());
    }

    boolean isSame(HttpServletRequest req) {
        if (this.client == this.getClient(req)) {
            return true;
        }
        this.client = 0;
        System.out.println("unmatched client");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean write(Supervisor sv, Page out, DataHolder holder) throws Exception {
        PageID id = out.getID();
        RedirectData data = null;
        HashMap<PageID, RedirectData> hashMap = this.pending;
        synchronized (hashMap) {
            data = this.pending.get(id);
        }
        id.getPageFactory().returnPage(out);
        if (data == null) {
            Option.trace("redirect pending data null", new Object[0]);
            return false;
        }
        if (holder.request.getURI().toString().indexOf(data.uri) < 0) {
            Option.trace("redirect path unmatched pending(%s) call(%s)", data.uri, holder.request.getURI().toString());
            return false;
        }
        sv.write(data.out_page, false, data.fw, holder);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Forward redirect(Page[] out_ret, Forward fw, RequestParameter req) throws Exception {
        RedirectData rd = new RedirectData();
        rd.fw = fw;
        rd.out_page = out_ret;
        URI uri = req.getURI();
        rd.uri = TransactionSequencer.makeRedirectURI(this.seq, out_ret[0].getID());
        String path = URIValue.makeAbsolutePath(URIValue.Scheme.getScheme(uri), uri.getPort(), rd.uri);
        HashMap<PageID, RedirectData> hashMap = this.pending;
        synchronized (hashMap) {
            this.pending.put(out_ret[0].getID(), rd);
        }
        return new Forward(new URI(path), false);
    }

    public void valueBound(HttpSessionBindingEvent ev) {
    }

    public void valueUnbound(HttpSessionBindingEvent ev) {
        if (!this.planed_clear) {
            this.hist.drop();
        }
    }
}

