/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ajax;

import java.util.*;

/**
 * 非同期通信蓄積情報。
 */
public class AjaxInformation {
	/**
	 * 蓄積キュー情報。
	 */
	public class QueueInformation {
		/**
		 * キューのキー。
		 */
		public final String key;
		/**
		 * キューのデータ数。
		 */
		public final int count;
		private QueueInformation( String k, int c ) {
			key = k;
			count = c;
		}
	}
	/**
	 * セッションID単位のグループ。
	 */
	public final String	group;
	/**
	 * 蓄積キュー情報。
	 */
	public final QueueInformation[]	queue;
	private AjaxInformation( String id, HashMap<String,LinkedList<AjaxHolder>> map ) {
		group = Integer.toString( id.hashCode() );
		queue = new QueueInformation[map.size()];
		int	cnt = 0;
		for ( String k : map.keySet() ) {
			LinkedList<AjaxHolder>	list = map.get( k );
			queue[cnt] = new QueueInformation( k, list.size() );
			cnt++;
		}
	}
	static AjaxInformation[] getInformation( HashMap<String, HashMap<String,LinkedList<AjaxHolder>>> map ) {
		AjaxInformation[]	ret = new AjaxInformation[map.size()];
		int	cnt = 0;
		for ( String id : map.keySet() ) {
			ret[cnt] = new AjaxInformation( id, map.get( id ) );
			cnt++;
		}
		return ret;
	}
}

