// Paraselene 2.1.1.8 (http://paraselene.sourceforge.jp/) generated this source file.
/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup.output.source.base;
public class Json extends paraselene.mockup.Output {
protected String getFileByte() { return
"package #1.#x;\n\nimport paraselene.*;\nimport paraselene.supervisor.*;\nimport paraselene.ajax.*;\nimport java.io.*;\nimport javax.servlet.http.*;\n\n/**\n * JSON非同期通信。\n */\npublic abstract class Json extends #1.SuperPage implements Downloadable {\n	private static final long serialVersionUID = 2L;\n\n	/**\n	 * クライアントの取得キーを表すパラメータ。\n	 */\n	protected static final String	KEY = \"key\";\n	private boolean	opera_f = false;\n	private JSON	data;\n	/**\n	 * コンストラクタ。\n	 */\n	public Json() {\n		super();\n		try {\n			setInitialized( true );\n		}\n		catch( Exception e ) {\n			Option.debug( e );\n		}\n	}\n	/**\n	 * ページIDの取得。\n	 * @return ページID。\n	 */\n	public PageID getID() {\n		return PageType.PARASELENE_JSON;\n	}\n	/**\n	 * ブラウザに403を返す。\n	 * @param req リクエスト内容。\n	 * @param fw デフォルト遷移先。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public Forward inputMain( RequestParameter req, Forward fw ) throws PageException {\n		return new Forward( 403 );\n	}\n	public boolean isHistoryClear() { return false; }\n	public boolean isAllowHistoryAdd() { return false; }\n	/**\n	 * 別名URI設定。\n	 * @return paraselene.json.na\n	 */\n	public String getAliasURI() {\n		return \"paraselene.json.na\";\n	}\n	/**\n	 * 出力情報のハンドリングを行う。\n	 * リクエストに応じて、固定のレスポンスを生成したい時はnull以外を返して下さい。\n	 * nullを返すと、Ajaxクラスにキューイングされたものを使用します。\n	 * @param req リクエスト内容。\n	 * @return レスポンスするインスタンス。null可。\n	 */\n	protected abstract Serializable outputMain( RequestParameter req ) throws PageException;\n	/**\n	 * 初回outputの呼び出しメイン処理。\n	 * @param req リクエスト内容。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public void firstOutputMain( RequestParameter req ) throws PageException{}\n\n	private class LastJson implements Serializable {\n		private static final long serialVersionUID = 2L;\n		RequestParameter	req;\n		JSON	json;\n		LastJson(){}\n		LastJson( RequestParameter r, JSON j ) {\n			req = r;\n			json = j;\n		}\n		JSON getLastJson( RequestParameter r ) {\n			if ( req.equals( r ) )	return json;\n			return null;\n		}\n	}\n\n	private static final String JSON_SESSION = \"paraselene$lastJson\";\n\n	/**\n	 * 出力情報の設定を行う。\n	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。\n	 * @param req リクエスト内容。\n	 * @return 出力ページ。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public Page outputMain( Page from, RequestParameter req ) throws PageException {\n		String[]	ua = req.getHeader( \"User-Agent\" );\n		if ( ua != null ) {\n			opera_f = ua[0].indexOf( \"Opera\" ) != -1;\n		}\n\n		data = null;\n		HttpSession	session = req.getSession();\n		LastJson	lj = (LastJson)session.getAttribute( JSON_SESSION );\n		if ( lj != null ) {\n			data = lj.getLastJson( req );\n			if ( data != null )	return this;\n		}\n		RequestItem	ajax = req.getItem( Supervisor.A_AJAX_KEY );\n		if ( ajax != null ) {\n			data = Ajax.get( session, ajax.getValue( 0 ) );\n		}\n		else {\n			Serializable	spot = outputMain( req );\n			if ( spot != null ) {\n				data = new JSON( spot );\n			}\n			else {\n				RequestItem	item = req.getItem( KEY );\n				if ( item == null )	return this;\n				data = Ajax.get( session, item.getValue( 0 ) );\n			}\n		}\n		session.setAttribute( JSON_SESSION, new LastJson( req, data ) );\n		return this;\n	}\n	/**\n	 * 出力コンテントタイプ。\n	 * @return text/javascript+json; charset=utf-8\n	 */\n	public String getContentType() {\n		return opera_f?\n			\"text/html; charset=utf-8\":\n			\"text/javascript+json; charset=utf-8\";\n	}\n\n	/**\n	 * キャッシュ禁止指定。\n	 * @return true:ブラウザキャッシュを禁止します。\n	 */\n	public boolean isNoCache() { return true; }\n\n	/**\n	 * 出力内容の取得。\n	 * @return ストリーム。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public InputStream getInputStream() throws PageException {\n		String	ret = \"{}\";\n		if ( data != null ) {\n			ret = data.toString();\n		}\n		try {\n			return new ByteArrayInputStream( ret.getBytes( \"utf-8\" ) );\n		}\n		catch( Exception e ) {\n			throw new PageException( e );\n		}\n	}\n}\n\n";}
}
