/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.form;


import java.io.*;
import java.net.*;
import paraselene.*;
import paraselene.tag.*;


/**
 * １行テキストボックス。<br>
 * パスワード入力用ボックスであれば、ブラウザへvalueを返しません。
 */
public class SingleTextBox extends Input {
	private static final long serialVersionUID = 2L;
	private boolean password_f = false;
	private boolean hidden_f = false;
	/**
	 * コンストラクタ。
	 * @param pw_f true:パスワード、false:平文。
	 */
	public SingleTextBox( boolean pw_f ) {
		super( pw_f?	Input.Type.PASSWORD: Input.Type.TEXT );
		password_f = pw_f;
	}

	/**
	 * パスワード入力であるか？
	 * @return pw_f true:パスワード、false:平文。
	 */
	public boolean isPassword() {
		return password_f;
	}

	protected Tag newReplica() {
		return copy4Replica( new SingleTextBox( password_f ) );
	}

	/**
	 * 開始タグの文字列。
	 * @return 開始タグ。
	 */
	protected synchronized String getFirstTag() {
		if ( !hidden_f )	return super.getFirstTag();

		boolean	xml = false;
		xml = getAssignedTag().getAssignedPage().isXML();
		StringBuilder	buf = new StringBuilder( "<" );
		buf = buf.append( getName() );
		for ( String k : attr.keySet() ) {
			if ( "value".equals( k ) ) continue;
			buf = buf.append( " " );
			buf = buf.append( attr.get( k ).toHtmlString( xml ) );
		}
		if ( xml && isSimpleTag() ) {
			buf = buf.append( " /" );
		}
		buf = buf.append( ">" );
		return buf.toString();
	}

	/**
	 * 出力。パスワードであれば、value値は出力しません。
	 * @param w ライター。
	 * @param mode 文字列種別。
	 */
	public void write( PrintWriter w, StringMode mode ) {
		if ( password_f ) {
			hidden_f = true;
		}
		super.write( w, mode );
		hidden_f = false;

	}

	public HTMLPart getReplica() {
		SingleTextBox	stb = (SingleTextBox)super.getReplica();
		stb.password_f = this.password_f;
		return stb;
	}

	/**
	 * 入力文字数チェック。maxlength属性値と設定文字列を比較します。
	 * null値は文字列長0として検査します。
	 * @param mes ControlException用メッセージ。
	 * @exception ControlException 文字数がmaxlength属性値を上回った場合。
	 */
	public void checkMaxLength( String mes ) throws ControlException {
		Attribute	attr = getAttribute( "maxlength" );
		checkMaxLength( mes, Integer.parseInt( attr.getString() ) );
	}

	/**
	 * トリム。設定文字列の前後の空白を除去します。
	 */
	public void trim() {
		trim( this );
	}
}


