package #1.#x;

import paraselene.*;
import paraselene.supervisor.*;
import java.io.*;

/**
 * JavaScript出力。
 */
public class Js extends #1.SuperPage implements Downloadable {
	private static final long serialVersionUID = 1L;
	private static final paraselene.mockup.js.paraselene_js	js =
		new paraselene.mockup.js.paraselene_js();

	/**
	 * コンストラクタ。
	 */
	public Js() {
		super();
		try {
			setInitialized( true );
		}
		catch( Exception e ) {
			Option.debug( e );
		}
	}
	/**
	 * ページIDの取得。
	 * @return ページID。
	 */
	public PageID getID() {
		return PageType.PARASELENE_JS;
	}
	/**
	 * ブラウザに403を返す。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Forward inputMain( RequestParameter req, Forward fw ) throws PageException {
		return new Forward( 403 );
	}
	public boolean isHistoryClear() { return false; }
	public boolean isAllowHistoryAdd() { return false; }
	/**
	 * 別名URI設定。
	 * @return paraselene.css.na
	 */
	public String getAliasURI() {
		return "paraselene.js.na";
	}
	/**
	 * 初回outputの呼び出しメイン処理。
	 * @param req リクエスト内容。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public void firstOutputMain( RequestParameter req ) throws PageException{}
	/**
	 * 出力情報の設定を行う。
	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Page outputMain( Page from, RequestParameter req ) throws PageException {
		return this;
	}
	/**
	 * 出力コンテントタイプ。
	 * @return text/css
	 */
	public String getContentType() {
		return "text/javascript";
	}
	/**
	 * 更新日。
	 * @return 更新日。
	 */
	public HTTPDate getLastModified() {
		return js.getDate();
	}
	/**
	 * 出力内容の取得。
	 * @return ストリーム。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public InputStream getInputStream() throws PageException {
		try {
			return js.getInputStream( getCharset() );
		}
		catch( Exception e ) {
			throw new PageException( e );
		}
	}
}

