/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.dyna;


import paraselene.tag.*;


/**
 * 独自派生クラスの置き換え。<br>
 * Tag の派生クラスを作成し、スケルトンソースの生成時や DynamicPage
 * 生成時にそれと置き換える事ができます。<br>
 * これを実装するクラスは、引数なしの public コンストラクタが必要です。
 */
public interface GrantTagProvider {
	/**
	 * 独自タグ割り当てインスタンスの取得。
	 * @param tag 元のタグ。属性値も持っています。
	 * @return 置き換えクラス生成用インスタンス。提供しない場合はnull。
	 * @exception DynamicPageException 継続不可能なエラーが発生した場合。
	 */
	GrantTag getGrantTag( Tag tag ) throws DynamicPageException;
}

