package #1;


import #1.#x.*;
import paraselene.*;
import paraselene.supervisor.*;
import paraselene.tag.*;
import paraselene.tag.form.*;
import paraselene.tag.list.*;
import paraselene.tag.table.*;
import paraselene.dyna.*;

/**
 * サイトページ基底クラス。
 * 全てのページの共通メソッドを持たせたい場合にはこのクラスに記述できます。
 */
public abstract class SuperPage extends Page {
	/**
	 * name 属性の検証。
	 * @param page 検証するページ
	 * @param exclude 検証から除外する name。
	 * @return エラーとなった name。
	 */
	public abstract NameDefine[] inspectName( Page page, String ... exclude );
	/**
	 * 入力値の検証メイン処理。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public abstract Forward inputMain( RequestParameter req, Forward fw ) throws PageException;
	/**
	 * 出力情報の設定メイン処理。
	 * @param from 遷移元ページ。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * nullを返すとthisをリターンしたのと同じ扱いにされます。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public abstract Page outputMain( Page from, RequestParameter req ) throws PageException;
	/**
	 * 初回outputの呼び出しメイン処理。
	 * @param req リクエスト内容。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public abstract void firstOutputMain( RequestParameter req ) throws PageException;

	/**
	 * コンストラクタ。
	 */
	public SuperPage() {
		super();
	}

	/**
	 * 出力文字コード。
	 * @return #2
	 */
	public String getCharset() {
		// 各ページで、出力文字コードを変更したい場合はオーバーライド
		// して下さい。
		// または、下記を直接書き換えて下さい。
		return "#2";
	}

	/**
	 * 出力コンテントタイプ。
	 * nullを返すと自動選定されます。選定方法は以下です。
	 * isXML()がtrueを返し、且つ
	 * （リクエストヘッダAcceptに application/xhtml+xml が明示されている、
	 * または携帯からのアクセスである）場合に
	 * application/xhtml+xml を返します。それ以外では text/html を返します。
	 * またその時、getCharset()の戻り値を charset に指定します。
	 * @return null。
	 */
	public String getContentType() {
		// 各ページで、コンテキストタイプを変更したい場合はオーバーライド
		// して下さい。
		return null;
	}

	/**
	 * 履歴追加方法。
	 * 過去に同一ページがあれば、直近からそのページまでの履歴をクリアする。
	 * trueならクリア、falseなら維持する。
	 * @return true
	 */
	public boolean isHistoryClear() {
		// 各ページで、履歴クリアをしたくない場合にはオーバーライドして
		// falseを返して下さい。
		return true;
	}

	/**
	 * 履歴追加許可。
	 * @return true
	 */
	public boolean isAllowHistoryAdd() {
		// 各ページで、履歴に追加したくない場合にはオーバーライドして
		// falseを返して下さい。
		return true;
	}

	/**
	 * アップロードファイルの最大バイト数。
	 * @return 負数なら無制限に受け付けます。
	 */
	public int getUploadMaxBytes() {
		// アップロードに制限をかける場合は下記を修正するか、
		// 各ページでオーバーライドして下さい。
		// ここでは2Mバイトを上限としています。
		return 1024 * 1024 * 2;
	}

	/**
	 * 処理済みリクエストの再呼び出しを検出するか？
	 * このページに遷移するためのURIを生成する際のリクエストID付与を
	 * コントロールします。trueを返すとリクエストIDが付与されます。
	 * @return true:検出する、false:検出しない。
	 */
	public boolean isCheckRepeatSameRequest() {
		// 各ページで、処理済みリクエストの再呼び出しを検出したい場合には
		// オーバーライドしてtrueを返して下さい。
		return false;
	}

	/**
	 * 初期化。
	 */
	public void init() {
		// 全ページ共通の初期化処理があれば記述して下さい。
	}

	/**
	 * AJAXサポート機能の指定。
	 * アクセス元が携帯である場合は、この戻り値が何であっても無効になります。
	 * これ自体か、各ページでオーバーライドしてサポートされたい機能を指定して下さい。
	 * @return AJAXサポート。
	 */
	public AjaxSupport getAjaxSupport() {
		return AjaxSupport.NO;
	}

	/**
	 * 入力値の検証を行う。
	 * このメソッドが呼ばれる際には必ずセッションが発生しています。
	 * 入力値のエラーチェックや入力値に即した動作を記述します。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public final Forward input( RequestParameter req, Forward fw ) throws PageException {
		// 共通処理等あれば記述して下さい。
		return inputMain( req, fw );
	}

	/**
	 * 初回outputの呼び出し直前にコールされます。初期化処理を記述します。
	 * @param req リクエスト内容。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public final void firstOutput( RequestParameter req ) throws PageException {
		// 共通処理等あれば記述して下さい。
		firstOutputMain( req );
	}

	/**
	 * 出力情報の設定を行う。
	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * nullを返すとthisをリターンしたのと同じ扱いにされます。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public final Page output( Page from, RequestParameter req ) throws PageException {
		// 共通処理等あれば記述して下さい。
		return outputMain( from, req );
	}
}

