/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import paraselene.HTTPDate;
import paraselene.supervisor.Option;

public class Version {
    public static final String VERSION = "2.1.2.1";
    private static final String SITE = " (http://paraselene.sourceforge.jp/)";
    private static final String TITLE = "Paraselene2 2.1.2.1 (http://paraselene.sourceforge.jp/)";
    private static final String[] CLASS_PATH = new String[]{"sun.boot.class.path", "java.ext.dirs", "java.class.path"};
    private static final File JAR_PATH = Version.seekJar();

    private Version() {
    }

    public static String getTitle() {
        return TITLE;
    }

    public static String getCopyRight() {
        return "Copyright 2009 Akira Terasaki";
    }

    private static boolean isHit(File f) {
        try {
            JarFile file = new JarFile(f);
            JarEntry ent = file.getJarEntry("paraselene/Version.class");
            return ent != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static File seekJar(File dir, boolean nest_f) {
        if (dir.isDirectory()) {
            if (nest_f) {
                return null;
            }
            File[] next = dir.listFiles();
            for (int i = 0; i < next.length; ++i) {
                File ret = Version.seekJar(next[i], true);
                if (ret == null) continue;
                return ret;
            }
        } else if (Version.isHit(dir)) {
            return dir;
        }
        return null;
    }

    private static File seekJar(String key) {
        String prop = System.getProperty(key);
        if (prop == null) {
            return null;
        }
        String[] dir = prop.split(File.pathSeparator);
        for (int i = 0; i < dir.length; ++i) {
            File ret = Version.seekJar(new File(dir[i].trim()), false);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private static File seekJar() {
        try {
            URL url = Version.class.getResource("/paraselene/Version.class");
            URI uri = new URI(url.toString().split("!")[0].substring(4));
            File file = new File(uri);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            for (int i = 0; i < CLASS_PATH.length; ++i) {
                File ret = Version.seekJar(CLASS_PATH[i]);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }
    }

    public static File getJarPath() {
        return JAR_PATH;
    }

    private static String fixName(String name) {
        String[] test = name.split("\\\\");
        StringBuilder buf = new StringBuilder(test[0]);
        for (int i = 1; i < test.length; ++i) {
            buf = buf.append("/");
            buf = buf.append(test[i]);
        }
        return buf.toString();
    }

    public static HTTPDate getLastModified(String name) {
        name = Version.fixName(name);
        try {
            JarFile file = new JarFile(Version.getJarPath());
            return new HTTPDate(new Date(file.getEntry(name).getTime()));
        }
        catch (Exception e) {
            Option.debug(e);
            return new HTTPDate(new Date(Version.getJarPath().lastModified()));
        }
    }

    public static InputStream getResource(String name) {
        InputStream is;
        name = Version.fixName(name);
        ClassLoader ld = Version.class.getClassLoader();
        if (ld != null && (is = ld.getResourceAsStream(name)) != null) {
            return is;
        }
        try {
            JarFile file = new JarFile(Version.getJarPath());
            return file.getInputStream(file.getJarEntry(name));
        }
        catch (Exception e) {
            Option.debug(e);
            return null;
        }
    }
}

