/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import paraselene.Page;
import paraselene.URIValue;
import paraselene.supervisor.CacheAjax;
import paraselene.supervisor.DataHolder;
import paraselene.supervisor.Forward;
import paraselene.supervisor.HistorySet;
import paraselene.supervisor.NullForward;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RedirectData;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.Supervisor;
import paraselene.supervisor.TransactionSequencer;

class SessionData
implements Serializable,
HttpSessionBindingListener {
    private static final long serialVersionUID = 25L;
    TransactionSequencer seq = new TransactionSequencer();
    HistorySet hist = null;
    private HashMap<PageID, RedirectData> pending = new HashMap();
    private volatile int client;
    private static final String DUMMY = "paraselene_dummy";
    private ArrayList<String> cache_dummy_key = new ArrayList();
    private ArrayList<CacheAjax> cache_ajax = new ArrayList();
    private HashMap<String, Waiter> working_ajax = new HashMap();
    private static final int CACHE_MAX = 5;
    boolean planed_clear = false;

    private String getCacheKey(RequestParameter param) {
        return param.makeCacheKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheEntry(RequestParameter param, CacheAjax ca) {
        String key = this.getCacheKey(param);
        if (key == null) {
            return;
        }
        ArrayList<String> arrayList = this.cache_dummy_key;
        synchronized (arrayList) {
            this.cache_dummy_key.add(key);
            this.cache_ajax.add(ca);
            if (this.cache_dummy_key.size() > 5) {
                this.cache_dummy_key.remove(0);
                this.cache_ajax.remove(0);
            }
        }
        this.cacheUnlock(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheUnlock(RequestParameter param) {
        if (param == null) {
            return;
        }
        String key = this.getCacheKey(param);
        if (key == null) {
            return;
        }
        Waiter o = null;
        Serializable serializable = this.working_ajax;
        synchronized (serializable) {
            o = this.working_ajax.remove(key);
        }
        if (o == null) {
            return;
        }
        serializable = o;
        synchronized (serializable) {
            o.flag = false;
            Option.trace("%s release", key);
            o.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Forward cacheResponse(RequestParameter param, HttpServletResponse res) throws IOException {
        String key = this.getCacheKey(param);
        if (key == null) {
            return null;
        }
        Waiter o1 = null;
        Waiter o2 = new Waiter();
        Serializable serializable = this.working_ajax;
        synchronized (serializable) {
            o1 = this.working_ajax.get(key);
            if (o1 == null) {
                Option.trace("%s ajax lock", key);
                this.working_ajax.put(key, o2);
            }
        }
        if (o1 != null) {
            serializable = o1;
            synchronized (serializable) {
                if (o1.flag) {
                    Option.trace("%s waiting", key);
                    while (true) {
                        try {
                            o1.wait();
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        break;
                    }
                }
            }
            return this.cacheResponse(param, res);
        }
        serializable = this.cache_dummy_key;
        synchronized (serializable) {
            for (int i = this.cache_dummy_key.size() - 1; i >= 0; --i) {
                String ck = this.cache_dummy_key.get(i);
                if (!ck.equals(key)) continue;
                this.cacheUnlock(param);
                CacheAjax ca = this.cache_ajax.get(i);
                ca.writeTo(res);
                Option.trace("used cache response", new Object[0]);
                return new NullForward();
            }
        }
        return null;
    }

    private String cut(String org, int len) {
        if (org == null) {
            return null;
        }
        int org_len = org.length();
        if (org_len < len) {
            len = org_len;
        }
        return org.substring(0, len);
    }

    private int getClient(HttpServletRequest req) {
        String[] data = new String[]{this.cut(req.getHeader("User-Agent"), 80), req.getRemoteAddr()};
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) {
                data[i] = "non";
            }
            buf = buf.append("*");
            buf = buf.append(data[i]);
        }
        String str = buf.toString();
        Option.trace(str, new Object[0]);
        return str.hashCode();
    }

    SessionData(HttpServletRequest req) {
        this.client = this.getClient(req);
        this.hist = new HistorySet(req.getSession().getId());
    }

    boolean isSame(HttpServletRequest req) {
        if (this.client == this.getClient(req)) {
            return true;
        }
        this.client = 0;
        System.out.println("unmatched client");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean write(Supervisor sv, Page out, DataHolder holder) throws Exception {
        PageID id = out.getID();
        RedirectData data = null;
        HashMap<PageID, RedirectData> hashMap = this.pending;
        synchronized (hashMap) {
            data = this.pending.get(id);
        }
        id.getPageFactory().returnPage(out);
        if (data == null) {
            Option.trace("redirect pending data null", new Object[0]);
            return false;
        }
        if (holder.request.getURI().toString().indexOf(data.uri) < 0) {
            Option.trace("redirect path unmatched pending(%s) call(%s)", data.uri, holder.request.getURI().toString());
            return false;
        }
        sv.write(data.out_page, false, data.fw, holder);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Forward redirect(Page[] out_ret, Forward fw, RequestParameter req) throws Exception {
        RedirectData rd = new RedirectData();
        rd.fw = fw;
        rd.out_page = out_ret;
        rd.posted = req.getURI();
        rd.uri = TransactionSequencer.makeRedirectURI(this.seq, out_ret[0].getID());
        String path = URIValue.makeAbsolutePath(URIValue.Scheme.getScheme(rd.posted), rd.posted.getPort(), rd.uri);
        HashMap<PageID, RedirectData> hashMap = this.pending;
        synchronized (hashMap) {
            this.pending.put(out_ret[0].getID(), rd);
        }
        rd.redirect_path = new URI(path);
        return new Forward(rd.redirect_path, false);
    }

    Forward redirect(URI post) {
        Collection<RedirectData> list = this.pending.values();
        for (RedirectData rd : this.pending.values()) {
            if (!rd.posted.equals(post)) continue;
            return new Forward(rd.redirect_path, false);
        }
        return null;
    }

    public void valueBound(HttpSessionBindingEvent ev) {
    }

    public void valueUnbound(HttpSessionBindingEvent ev) {
        if (!this.planed_clear) {
            this.hist.drop();
        }
    }

    private class Waiter
    implements Serializable {
        private static final long serialVersionUID = 25L;
        volatile boolean flag = true;

        private Waiter() {
        }
    }
}

