/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.form;

import paraselene.Page;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;
import paraselene.tag.form.Control;
import paraselene.tag.form.Form;
import paraselene.tag.form.Input;
import paraselene.tag.form.RadioGroup;

public class CheckBox
extends Input {
    private static final long serialVersionUID = 2L;
    private boolean radio_flag = false;
    private RadioGroup radio = null;

    void setRadioGroup(RadioGroup r) {
        this.radio = r;
    }

    public RadioGroup getRadioGroup() {
        return this.radio;
    }

    public CheckBox(boolean radio_f) {
        super(radio_f ? Input.Type.RADIO : Input.Type.CHECK);
        this.radio_flag = radio_f;
    }

    @Override
    protected Tag newReplica() {
        return this.copy4Replica(new CheckBox(this.radio_flag));
    }

    public boolean isRadio() {
        return this.radio_flag;
    }

    @Override
    public void setAttribute(Attribute at) {
        if (this.radio_flag && "name".equals(at.getName())) {
            at = new NameAttribute(at.getString());
        }
        super.setAttribute(at);
    }

    public static void setRadio(Form form, String name, String val) {
        name = Page.getIndexName(name);
        Control[] tag = form.getAllControl(name);
        for (int i = 0; i < tag.length; ++i) {
            if (!(tag[i] instanceof CheckBox)) continue;
            CheckBox box = (CheckBox)tag[i];
            if (!box.radio_flag) continue;
            if (val == null) {
                Control.Status.CHECKED.set(box, false);
                continue;
            }
            Control.Status.CHECKED.set(box, val.equals(box.getValueString()));
        }
    }

    public static String getRadio(Form form, String name) {
        name = Page.getIndexName(name);
        Control[] tag = form.getAllControl(name);
        for (int i = 0; i < tag.length; ++i) {
            if (!(tag[i] instanceof CheckBox)) continue;
            CheckBox box = (CheckBox)tag[i];
            if (!box.radio_flag || !box.isChecked()) continue;
            return box.getValueString();
        }
        return null;
    }

    public static void setRadio(Tag[] group, String val) {
        for (int i = 0; i < group.length; ++i) {
            if (!(group[i] instanceof CheckBox)) continue;
            CheckBox box = (CheckBox)group[i];
            if (!box.radio_flag) continue;
            String v = box.getValueString();
            boolean flag = false;
            if (v != null) {
                flag = v.equals(val);
            }
            Control.Status.CHECKED.set(box, flag);
        }
    }

    public static String getRadio(Tag[] group) {
        for (int i = 0; i < group.length; ++i) {
            if (!(group[i] instanceof CheckBox)) continue;
            CheckBox box = (CheckBox)group[i];
            if (!box.radio_flag || !box.isChecked()) continue;
            return box.getValueString();
        }
        return null;
    }

    public boolean isChecked() {
        return Control.Status.CHECKED.isSet(this);
    }

    public void setChecked(boolean flag) {
        if (this.radio_flag && flag) {
            Tag[] tag = this.getAssignedTag().getAssignedPage().getAllTagByType("form");
            for (int i = 0; i < tag.length; ++i) {
                Form form;
                if (!(tag[i] instanceof Form) || !(form = (Form)tag[i]).isContained(this)) continue;
                CheckBox.setRadio(form, this.getName(), this.getValueString());
                break;
            }
            return;
        }
        Control.Status.CHECKED.set(this, flag);
    }

    class NameAttribute
    extends Attribute {
        private boolean flag;

        NameAttribute(String v) {
            super("name", v);
            this.flag = false;
        }

        @Override
        protected String getValueString() {
            if (this.flag) {
                return Page.getIndexName(super.getValueString());
            }
            return super.getValueString();
        }

        @Override
        public String toHtmlString(boolean xml) {
            this.flag = true;
            String ret = super.toHtmlString(xml);
            this.flag = false;
            return ret;
        }
    }
}

