/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.form;

import java.util.ArrayList;
import paraselene.Page;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;
import paraselene.tag.VirtualTag;
import paraselene.tag.form.CheckBox;
import paraselene.tag.form.Control;
import paraselene.tag.form.Form;

public class RadioGroup
extends Control
implements VirtualTag {
    private static final long serialVersionUID = 2L;
    private Form form = null;
    private ArrayList<CheckBox> radio = new ArrayList();

    public RadioGroup() {
        super("radiogroup", false);
    }

    public RadioGroup(Tag ... tag) {
        this();
        this.addCheckBox(tag);
    }

    @Override
    protected Tag newReplica() {
        return this.copy4Replica(new RadioGroup());
    }

    public void addCheckBox(Tag ... tag) {
        for (int i = 0; i < tag.length; ++i) {
            CheckBox cb;
            if (!(tag[i] instanceof CheckBox) || !(cb = (CheckBox)tag[i]).isRadio()) continue;
            if (this.form == null) {
                this.form = cb.getForm();
            } else if (this.form != cb.getForm()) continue;
            RadioGroup r = cb.getRadioGroup();
            if (r != null) {
                r.removeCheckBox(cb);
            }
            this.radio.add(cb);
            cb.setRadioGroup(this);
        }
    }

    public void removeCheckBox(Tag ... tag) {
        block0: for (int i = 0; i < tag.length; ++i) {
            int cnt = this.radio.size();
            for (int j = 0; j < cnt; ++j) {
                CheckBox cb = this.radio.get(j);
                if (cb != tag[i]) continue;
                this.radio.remove(j);
                cb.setRadioGroup(null);
                continue block0;
            }
        }
    }

    @Override
    public Form getForm() {
        if (this.form != null) {
            return this.form;
        }
        int cnt = this.radio.size();
        if (cnt == 0) {
            return null;
        }
        this.form = this.radio.get(0).getForm();
        return this.form;
    }

    @Override
    public Page getAssignedPage() {
        int cnt = this.radio.size();
        if (cnt == 0) {
            return super.getAssignedPage();
        }
        return this.radio.get(0).getAssignedPage();
    }

    public CheckBox[] getCheckBox() {
        return this.radio.toArray(new CheckBox[0]);
    }

    public void rename(String name) {
        CheckBox[] cb = this.getCheckBox();
        for (int i = 0; i < cb.length; ++i) {
            cb[i].setAttribute(new Attribute("name", name));
        }
    }

    @Override
    public String getValueString() {
        return CheckBox.getRadio(this.getCheckBox());
    }

    @Override
    public void setValueString(String v) {
        CheckBox.setRadio(this.getCheckBox(), v);
    }
}

