/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import paraselene.*;

/**
 * 遷移先指定。output するページをポップアップ表示します。<br>
 * ただし、遷移元ページのgetAjaxSupportが有効でない場合は、通常の Forward と等価です。
 */
public class Popup extends Forward implements AjaxForward {
	private static final long serialVersionUID = 2L;
	Page active_page = null;
	/**
	 * ポップアップ種別。
	 */
	public enum Type {
		/**
		 * ポップアップの下のページのUI操作を許す。
		 */
		MODELESS( false, true ),
		/**
		 * ポップアップの下のページのUI操作を禁止する。
		 */
		MODAL( true, true ),
		/**
		 * タイトルバーの無いモーダルダイアログ。
		 */
		LITE_MODAL( true, false );
		private boolean modal_f;
		private boolean move_f;
		private Type( boolean md_f, boolean mv_f ) {
			modal_f = md_f;
			move_f = mv_f;
		}
		/**
		 * タイトルバーの有無。
		 * @return true:存在する、false:存在しない。
		 */
		public boolean isTitle() {
			return move_f;
		}
		/**
		 * モーダルであるか？
		 * @return true:モーダル、false:モードレス。
		 */
		public boolean isMode() {
			return modal_f;
		}
		/**
		 * モーダルであるか？
		 * @return true:モーダル、false:モードレスまたはダイアログではない。
		 */
		public static boolean isMode( Page page ) {
			Type	ptype = page.getPopupType();
			if ( ptype == null )	return false;
			return ptype.isMode();
		}
	}

	private Type type;

	/**
	 * コンストラクタ。
	 * @param id 指定ページのポップアップ。
	 * @param dialog_type ポップアップ種別。
	 */
	public Popup( PageID id, Type dialog_type ) {
		super( id );
		type = dialog_type;
		if ( isModelessAlert( type, SandBox.getCurrentRequestParameter().getHistory(), false ) ) {
			overwriteType( Type.MODAL );
		}
	}

	static boolean isModeless( Type mine ) {
		if ( mine == null )	return false;
		return !mine.isMode();
	}

	static boolean isModelessAlert( Type mine, History hist, boolean unlock_f ) {
		if ( hist == null )	return false;
		if ( mine == null )	return false;
		if ( mine.isMode() )	return false;
		try {
			Page[]	page = hist.getBrowsingPage();
			for ( int i = 0; i < page.length; i++ ) {
				Type	ptype = page[i].getPopupType();
				if ( ptype == null )	continue;
				if ( ptype.isMode() )	return true;
			}
		}
		finally {
			if ( unlock_f )	hist.unlock();
		}
		return false;
	}

	/**
	 * コンストラクタ。
	 * 指定ページの Z順を手前にします。
	 * @param page MODELESSのポップアップ。
	 */
	public Popup( Page page ) {
		this( page.getID(), Type.MODELESS );
		active_page = page;
	}

	Page getPage( Page from ) {
		if ( active_page != null ) {
			Option.trace( "Popup#getPage -> %s", active_page.getUniqueKey() );
			return active_page;
		}
		if ( out_page == null ) {
			Option.trace( "Popup#getPage -> null" );
			return null;
		}
		Page	p = out_page.getPageFactory().getPage( out_page.getID() );
		Option.trace( "Popup#getPage -> %s", p.getUniqueKey() );
		return p;
	}

	void overwriteType( Type t ) {
		if ( type == null )	return;
		if ( t == Type.MODELESS )	return;
		type = t;
	}

	Type getType() {
		return type;
	}

	/**
	 * 同じ動作であるか？
	 * 常にfalseを返します。
	 * @param o 比較対象。
	 * @return true:同一動作、false:異なる動作。
	 */
	public boolean equals( Object o ) {
		return false;
	}

	public String toString() {
		StringBuilder	buf = new StringBuilder( "Popup " );
		if ( active_page != null ) {
			buf = buf.append( "active:" );
			buf = buf.append( active_page.getID().toString() );
			buf = buf.append( "/" ).append( active_page.getUniqueKey() );
		}
		else {
			buf = buf.append( "open:" );
			buf = buf.append( getPageID().toString() );
			buf = buf.append( "/" ).append( type.toString() );
		}
		return buf.toString();
	}

	OutputCall makeOutput( int nk, Page lp, RequestParameter r, SessionData sd ) {
		Option.trace( "new OpenOutput <- %s", this );
		return new OpenOutput( nk, lp, this, getType(), r, sd );
	}
}

