/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletResponse;
import paraselene.Downloadable;
import paraselene.Page;
import paraselene.supervisor.CacheAjax;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SessionData;

class CacheBin
implements CacheAjax {
    private boolean gzip;
    private byte[] buf = new byte[65536];
    private int size;
    private String ctype;

    CacheBin(String mime, boolean gzip_f) {
        this.ctype = mime;
        this.gzip = gzip_f;
    }

    private OutputStream getOutpuStream(HttpServletResponse res) throws IOException {
        if (this.gzip) {
            return new GZIPOutputStream((OutputStream)res.getOutputStream());
        }
        return new BufferedOutputStream((OutputStream)res.getOutputStream());
    }

    private void flush(OutputStream out) throws IOException {
        if (out instanceof GZIPOutputStream) {
            ((GZIPOutputStream)out).finish();
            return;
        }
        out.flush();
    }

    private void write_once(RequestParameter param, SessionData data, HttpServletResponse res) throws IOException {
        res.setContentLength(this.size);
        OutputStream out = this.getOutpuStream(res);
        out.write(this.buf, 0, this.size);
        this.flush(out);
        byte[] tmp = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            tmp[i] = this.buf[i];
        }
        this.buf = tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Downloadable dl, RequestParameter param, SessionData data, HttpServletResponse res) throws IOException, Page.PageException {
        BufferedInputStream in = new BufferedInputStream(dl.getInputStream());
        try {
            this.size = in.read(this.buf);
            if (this.size < this.buf.length) {
                this.write_once(param, data, res);
                return;
            }
            OutputStream out = this.getOutpuStream(res);
            do {
                out.write(this.buf, 0, this.size);
                if (this.size < this.buf.length) break;
                this.size = in.read(this.buf);
            } while (this.size > 0);
            this.flush(out);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Override
    public void writeTo(HttpServletResponse res) throws IOException {
        if (this.gzip) {
            res.addHeader("Content-Encoding", "gzip");
        }
        res.setContentType(this.ctype);
        res.setContentLength(this.size);
        OutputStream out = this.getOutpuStream(res);
        out.write(this.buf, 0, this.size);
        this.flush(out);
    }
}

