/*
 * Decompiled with CFR 0.152.
 */
package paraselene.mockup;

import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import paraselene.Color;
import paraselene.HTMLPart;
import paraselene.Text;
import paraselene.WebColor;
import paraselene.dyna.mockup.URIHandle;
import paraselene.mockup.Make;
import paraselene.mockup.Output;
import paraselene.mockup.OutputNo;
import paraselene.mockup.Param;
import paraselene.mockup.PrePage;
import paraselene.mockup.output.Readme;
import paraselene.mockup.output.build;
import paraselene.mockup.output.source.base.Json;
import paraselene.mockup.output.source.base.PageLoader;
import paraselene.mockup.output.source.base.PageType;
import paraselene.mockup.output.web;
import paraselene.supervisor.TransactionSequencer;
import paraselene.tag.Tag;
import paraselene.tag.attr.Attribute;
import paraselene.tag.attr.ColorAttribute;
import paraselene.tag.table.Column;
import paraselene.tag.table.Line;
import paraselene.tag.table.Table;

public class Linker
extends Readme
implements OutputNo {
    private ArrayList<String> org_html = new ArrayList();
    private HashMap<String, PrePage> page_map = new HashMap();
    private ArrayList<String> ex_file = new ArrayList();
    private HashMap<String, String> ex_map = new HashMap();
    private PrePage crt_page = null;
    public static boolean flag = false;
    public static Linker readme = new Linker();

    @Override
    public String getString(int no) {
        int cnt = this.org_html.size();
        StringBuffer buf = new StringBuffer();
        boolean json_f = Boolean.valueOf(Param.JSON.get());
        switch (no) {
            case 1: {
                return Param.PACKAGE.get();
            }
            case 2: {
                if (json_f) {
                    buf = buf.append("/**\n * Json\n */\nPARASELENE_JSON(-1),\n");
                }
                for (int i = 0; i < cnt; ++i) {
                    PrePage page = this.page_map.get(this.org_html.get(i));
                    buf = buf.append("/**\n * ");
                    buf = buf.append(page.getMyselfURI().getPath());
                    buf = buf.append("\n */\n");
                    buf = buf.append(page.getEnumName(true));
                    buf = buf.append("(");
                    buf = buf.append(page.getID().getID());
                    buf = buf.append(i == cnt - 1 ? ");\n" : "),\n");
                }
                return buf.toString();
            }
            case 3: {
                if (json_f) {
                    buf = buf.append("page=new ");
                    buf = buf.append(Param.PACKAGE.get());
                    buf = buf.append(".Json();\n");
                    buf = buf.append("pf.addDefine(PARASELENE_JSON,page.getClass());\n");
                    buf = buf.append("map.put(PARASELENE_JSON.id,PARASELENE_JSON);\n");
                    buf = buf.append("pf.returnPage(page);\n");
                }
                for (int i = 0; i < cnt; ++i) {
                    PrePage page = this.page_map.get(this.org_html.get(i));
                    buf = buf.append("page=new ");
                    buf = buf.append(page.getClassName());
                    buf = buf.append("();\n");
                    buf = buf.append("pf.addDefine(");
                    buf = buf.append(page.getEnumName(true));
                    buf = buf.append(",page.getClass());\n");
                    buf = buf.append("map.put(");
                    buf = buf.append(page.getEnumName(true));
                    buf = buf.append(".id,");
                    buf = buf.append(page.getEnumName(true));
                    buf = buf.append(");\n");
                    buf = buf.append("pf.returnPage(page);\n");
                }
                return buf.toString();
            }
            case 4: {
                return Param.OUT_SOURCE_PATH.get();
            }
        }
        return null;
    }

    Linker() {
        this.init();
        Tag meta = new Tag("meta", true);
        meta.setAttribute(new Attribute("http-equiv", "Content-Type"), new Attribute("content", "text/html; charset=UTF-8"));
        Tag[] head = this.getAllTagByType("head");
        head[0].addHTMLPart(0, (HTMLPart)meta);
    }

    void entryPage(PrePage page) {
        String uri = page.getMyselfURI().toString();
        this.org_html.add(uri);
        this.page_map.put(uri, page);
    }

    void entryExclude(String path) {
        path = Output.toHtmlPath(path);
        if ((path = path.substring(Param.HTML_ROOT.get().length())).charAt(0) == '/') {
            path = path.substring(1);
        }
        this.ex_file.add(path);
        this.ex_map.put(path, path);
    }

    private void makeBase() throws Exception {
        Output[] output = new Output[]{new PageLoader(), new PageType(), Boolean.valueOf(Param.JSON.get()) != false ? new Json() : null};
        String[] name = new String[]{"PageLoader.java", "PageType.java", "Json.java"};
        for (int i = 0; i < name.length; ++i) {
            if (output[i] == null) continue;
            StringBuffer out_path = new StringBuffer(Make.SRC_PATH);
            out_path = out_path.append(File.separator);
            out_path = out_path.append("base");
            out_path = out_path.append(File.separator);
            out_path = out_path.append(name[i]);
            String p_name = out_path.toString();
            output[i].write(new File(p_name), this, Long.MAX_VALUE);
            readme.echoln(p_name + " output ended.");
        }
    }

    private void makeWeb() throws Exception {
        Output[] output = new Output[]{new build(), new web()};
        String[] name = new String[]{"build.xml", "web.xml"};
        for (int i = 0; i < name.length; ++i) {
            StringBuffer buf = new StringBuffer(Param.OUT_PATH.get());
            buf = buf.append(File.separator);
            File file = new File((buf = buf.append(name[i])).toString());
            if (file.exists()) {
                readme.echoln(file.toString() + " is not output, because it already exists.");
                continue;
            }
            output[i].write(file, this, Long.MAX_VALUE);
            readme.echoln(file.toString() + " output ended.");
        }
    }

    private void makeReadMe() throws Exception {
        int i;
        String path;
        Line l;
        this.getTitleTitle().setValueString(Param.PACKAGE.get());
        this.getRootTd().setValueString("<" + Param.OUT_PATH.get() + ">");
        this.getSourceTd().setValueString(" <" + Param.OUT_SOURCE_PATH.get() + ">");
        Table table = this.getClassListTable();
        Line line = table.getLineReplica(1);
        table.removeLine(1, -1);
        int cnt = this.org_html.size();
        String ex_path = null;
        for (int i2 = 0; i2 < cnt; ++i2) {
            PrePage page = this.page_map.get(this.org_html.get(i2));
            l = (Line)line.getReplica();
            path = page.getMyselfURI().getPath();
            l.setValueString(0, Integer.toString(i2 + 1), Output.toOSPath(path), page.getTitle(), page.getClassName(), page.getEnumName(false), TransactionSequencer.makeURI(null, null, page.getID()));
            String note = page.getNote();
            if (note == null) {
                note = "";
            }
            Column[] column = l.getColumnArray();
            if (!note.isEmpty()) {
                Column note_column = column[column.length - 1];
                note_column.setValueString(note);
                note_column.setAttribute((Attribute)new ColorAttribute("bgcolor", new Color(WebColor.YELLOW)));
            }
            Column path_clm = column[column.length - 2];
            String path_str = path_clm.getValueString();
            if (ex_path == null) {
                ex_path = path_str;
            }
            Tag tag = new Tag("a", false);
            tag.setAttribute(new Attribute("href", "javascript:load('" + path_str + "');"));
            tag.setValueString(path_str);
            path_clm.removeHTMLPart();
            path_clm.addHTMLPart((HTMLPart)tag);
            table.addLine(l);
        }
        Tag[] ex = this.getExTags();
        for (i = 0; i < ex.length; ++i) {
            ex[i].setValueString(ex_path);
        }
        table = this.getExListTable();
        line = table.getLineReplica(1);
        table.removeLine(1, -1);
        cnt = this.ex_file.size();
        for (i = 0; i < cnt; ++i) {
            l = (Line)line.getReplica();
            path = this.ex_file.get(i);
            l.setValueString(0, Integer.toString(i + 1), Output.toOSPath(path), Param.OTHER.get() + "/" + this.ex_file.get(i));
            table.addLine(l);
        }
        StringBuffer buf = new StringBuffer(Param.OUT_PATH.get());
        buf = buf.append(File.separator);
        buf = buf.append("Readme.html");
        String name = buf.toString();
        PrintWriter pw = new PrintWriter(name, "UTF-8");
        this.write(pw);
        pw.close();
        readme.echoln(name + " output ended.");
    }

    void output() throws Exception {
        Collections.sort(this.org_html);
        Collections.sort(this.ex_file);
        int cnt = this.org_html.size();
        for (int i = 0; i < cnt; ++i) {
            PrePage page = this.page_map.get(this.org_html.get(i));
            page.makeSource();
        }
        this.makeBase();
        this.makeWeb();
        this.makeReadMe();
    }

    void setCurrentPage(PrePage p) {
        this.crt_page = p;
    }

    public void addNote(String s) {
        if (this.crt_page == null) {
            return;
        }
        this.crt_page.addNote(s);
    }

    private String fixPath(String path) {
        String[] part = path.split("[/\\\\]");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < part.length; ++i) {
            if (part[i].length() == 0 || ".".equals(part[i])) continue;
            if ("..".equals(part[i])) {
                int size = list.size();
                if (size == 0) {
                    return null;
                }
                list.remove(size - 1);
                continue;
            }
            list.add(part[i]);
        }
        int size = list.size();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buf = buf.append((String)list.get(i));
            if (i == size - 1) continue;
            buf = buf.append("/");
        }
        return buf.toString();
    }

    String resolvePath(URI uri) throws Exception {
        URIHandle.URIProcess process;
        URIHandle handle = new URIHandle(uri, URIHandle.URIProcess.FULL_PROCESS);
        String uri_str = uri.toString();
        if (Param.uri_pp != null) {
            String uri_str_new;
            URIHandle handle_new = null;
            try {
                handle_new = Param.uri_pp.getHandle(this.crt_page.getClassName(), uri);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            if (handle_new != null && !(uri_str_new = (uri = (handle = handle_new).getURI()).toString()).equals(uri_str)) {
                StringBuffer note = new StringBuffer("URIPreProcess\u306b\u3088\u308a ");
                note = note.append(uri_str);
                note = note.append(" \u304c ");
                note = note.append(uri_str_new);
                note = note.append(" \u306b\u5909\u63db\u3055\u308c\u307e\u3057\u305f\u3002");
                this.addNote(note.toString());
                uri_str = uri_str_new;
            }
        }
        if ((process = handle.getURIProcess()) == URIHandle.URIProcess.NO_PROCESS) {
            StringBuffer note = new StringBuffer("URIPreProcess\u306b\u3088\u308a ");
            note = note.append(uri_str);
            note = note.append(" \u306f URI\u89e3\u6c7a\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            this.addNote(note.toString());
            return Make.escape(uri_str);
        }
        if (uri_str.charAt(0) == '#') {
            return Make.escape(uri_str);
        }
        if (uri.getScheme() != null) {
            this.addNote("\u7d76\u5bfe\u30d1\u30b9\u304c\u3042\u308a\u307e\u3057\u305f(" + uri_str + ")");
            return Make.escape(uri_str);
        }
        String path = uri.getPath();
        if (path.charAt(0) == '/') {
            this.addNote("\u30eb\u30fc\u30c8\u304b\u3089\u306e\u30d1\u30b9\u304c\u3042\u308a\u307e\u3057\u305f(" + path + ")");
            return Make.escape(uri_str);
        }
        uri = this.crt_page.getMyselfURI().resolve(uri);
        path = this.fixPath(uri.getPath());
        PrePage page = this.page_map.get(path);
        if (page != null) {
            String sch;
            StringBuffer buf = new StringBuffer("paraselene.tag.attr.URIAttribute.pageToURI(");
            buf = buf.append(page.getEnumName(false));
            buf = buf.append(",");
            String frag = uri.getFragment();
            buf = frag == null ? buf.append("null") : buf.append(Make.escape(frag));
            String query = uri.getQuery();
            if (query != null) {
                String[] q_part = query.split("&");
                for (int i = 0; i < q_part.length; ++i) {
                    buf = buf.append(",");
                    buf = buf.append(Make.escape(q_part[i]));
                }
            }
            buf = buf.append(")");
            int port = uri.getPort();
            if (port == -1) {
                port = 0;
            }
            if ((sch = uri.getScheme()) != null) {
                StringBuffer sub = new StringBuffer("paraselene.tag.attr.URIAttribute.makeAbsolutePath(");
                sub = sub.append("http".equals(sch) ? "paraselene.tag.attr.URIAttribute.Scheme.HTTP," : "paraselene.tag.attr.URIAttribute.Scheme.HTTPS,");
                sub = sub.append(port);
                sub = sub.append(",");
                sub = sub.append(buf);
                buf = sub.append(")");
            }
            return buf.toString();
        }
        if (process == URIHandle.URIProcess.NOT_USE_OTHER) {
            StringBuffer note = new StringBuffer("URIPreProcess\u306b\u3088\u308a ");
            note = note.append(uri_str);
            note = note.append(" \u306f ");
            note = note.append(Param.OTHER.key);
            note = note.append(" \u3092\u9069\u7528\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            this.addNote(note.toString());
            return Make.escape(uri_str);
        }
        String ex_path = Output.toHtmlPath(path);
        String ex = this.ex_map.get(ex_path);
        if (ex != null) {
            String frag;
            String str = Param.OTHER.get().trim();
            StringBuffer buf = new StringBuffer(str);
            if (str.charAt(str.length() - 1) != '/') {
                buf = buf.append("/");
            }
            buf = buf.append(ex_path);
            String query = uri.getQuery();
            if (query != null) {
                buf = buf.append("?");
                buf = buf.append(query);
            }
            if ((frag = uri.getFragment()) != null) {
                buf = buf.append("#");
                buf = buf.append(frag);
            }
            return Make.escape(new URI(buf.toString()).toString());
        }
        this.addNote("\u8b66\u544a:" + path + "\u304c\u89e3\u6c7a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        return Make.escape(uri_str);
    }

    public void echo(String str) {
        if (!flag) {
            return;
        }
        Tag div = this.getEchoDiv();
        Text text = null;
        if (div.getHTMLPartCount() == 0) {
            text = new Text("");
            div.addHTMLPart((HTMLPart)text);
        } else {
            text = (Text)div.getHTMLPart(0);
        }
        text.append(str);
        System.out.print(str);
    }

    public void echoln(String str) {
        this.echo(str + "\n");
    }
}

