/*
 * Decompiled with CFR 0.152.
 */
package paraselene.mockup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import paraselene.Version;
import paraselene.dyna.DynamicPageException;
import paraselene.mockup.Config;
import paraselene.mockup.Download;
import paraselene.mockup.HtmlExt;
import paraselene.mockup.Linker;
import paraselene.mockup.Output;
import paraselene.mockup.OutputNo;
import paraselene.mockup.Param;
import paraselene.mockup.PrePage;
import paraselene.mockup.output.source.DummyPage;
import paraselene.mockup.output.source.Gate;
import paraselene.mockup.output.source.Json;
import paraselene.mockup.output.source.SuperPage;

public class Make
implements OutputNo {
    static String SRC_PATH = "source";
    private static final String EXCLUDE = "exclude";

    @Override
    public String getString(int no) {
        switch (no) {
            case 1: {
                return Param.PACKAGE.get();
            }
            case 2: {
                return Param.OUT_ENCODE.get();
            }
        }
        return null;
    }

    static String escape(String s) {
        if (s == null) {
            return "null";
        }
        char[] ch = s.toCharArray();
        StringBuffer buf = new StringBuffer("\"");
        for (int i = 0; i < ch.length; ++i) {
            buf = ch[i] == '\n' ? buf.append("\\n") : (ch[i] == '\"' ? buf.append("\\\"") : (ch[i] == '\\' ? buf.append("\\\\") : buf.append(ch[i])));
        }
        buf = buf.append("\"");
        return buf.toString();
    }

    private static void ex_copy(File ex) throws IOException {
        int len;
        StringBuffer out_path = new StringBuffer(Param.OUT_PATH.get());
        out_path = out_path.append(File.separator);
        out_path = out_path.append(EXCLUDE);
        out_path = out_path.append(File.separator);
        try {
            out_path = out_path.append(ex.getParent().substring(Param.HTML_ROOT.get().length()));
        }
        catch (Exception e) {
            // empty catch block
        }
        Output.mkdir(out_path.toString());
        out_path = out_path.append(File.separator);
        out_path = out_path.append(ex.getName());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(out_path.toString()));
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(ex));
        byte[] buf = new byte[32768];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    private static void read(File root) throws FileNotFoundException, UnsupportedEncodingException, IOException, DynamicPageException {
        if (!root.exists()) {
            System.err.println(root.getPath() + "is not found.");
            System.exit(1);
        }
        File[] list = root.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                if (Param.isIgnoreDir(list[i].getName())) {
                    Linker.readme.echoln(list[i].getPath() + " is ignored.");
                    continue;
                }
                Make.read(list[i]);
                continue;
            }
            if (Param.isHit(list[i].getName())) {
                String[] fp = list[i].getName().split("\\.");
                String ext = fp[fp.length - 1];
                PrePage page = null;
                Linker.readme.echoln(list[i].getPath() + " parsing starts.");
                page = HtmlExt.isHtml(ext) ? new PrePage(list[i]) : new Download(list[i]);
                Linker.readme.entryPage(page);
                Linker.readme.echoln(list[i].getPath() + " parsing ended.");
                continue;
            }
            Make.ex_copy(list[i]);
            Linker.readme.entryExclude(list[i].getPath());
            Linker.readme.echoln(list[i].getPath() + " was copied.");
        }
    }

    private static void write() throws Exception {
        Output[] output = new Output[]{new DummyPage(), new Gate(), new SuperPage(), Boolean.valueOf(Param.JSON.get()) != false ? new Json() : null};
        String[] name = new String[]{"DummyPage.java", "Gate.java", "SuperPage.java", "Json.java"};
        Make mk = new Make();
        for (int i = 0; i < name.length; ++i) {
            if (output[i] == null) continue;
            StringBuffer buf = new StringBuffer(SRC_PATH);
            buf = buf.append(File.separator);
            String p_name = (buf = buf.append(name[i])).toString();
            File file = new File(p_name);
            if (file.exists()) {
                Linker.readme.echoln(file.toString() + " is not output, because it already exists.");
                continue;
            }
            output[i].write(file, mk, Long.MAX_VALUE);
            Linker.readme.echoln(file.toString() + " was output.");
        }
    }

    public static void main(String[] argc) throws Exception {
        Linker.flag = true;
        Date start = new Date();
        Linker.readme.echoln(Version.getTitle());
        System.out.println(Version.getCopyRight());
        Linker.readme.echoln(start.toString());
        Linker.readme.echoln("");
        Linker.readme.echoln(System.getProperty("java.vendor", "unknown vendor") + " " + System.getProperty("java.vm.name", "JAVA VM") + " " + System.getProperty("java.version", ""));
        Linker.readme.echoln(System.getProperty("os.name", "unknown OS") + " " + System.getProperty("os.version", ""));
        Linker.readme.echoln("\n");
        Param.helpParam(argc);
        File file = new File("paraselene.cfg");
        if (file.exists()) {
            Config.load(file);
        }
        Param.setParam(argc);
        Param.loadParam();
        StringBuffer buf = new StringBuffer(Param.OUT_PATH.get());
        buf = buf.append(File.separator);
        buf = buf.append(SRC_PATH);
        String[] part = Param.PACKAGE.get().split("\\.");
        for (int i = 0; i < part.length; ++i) {
            buf = buf.append(File.separator);
            buf = buf.append(part[i]);
        }
        SRC_PATH = buf.toString();
        if (Boolean.valueOf(Param.CLEAR.get()).booleanValue()) {
            Linker.readme.echoln("<DELETE PHASE>");
            buf = new StringBuffer(Param.OUT_PATH.get());
            buf = buf.append(File.separator);
            buf = buf.append(EXCLUDE);
            Output.rmdir(buf.toString());
            buf = new StringBuffer(SRC_PATH);
            buf = buf.append(File.separator);
            buf = buf.append(PrePage.out_dir[0]);
            Output.rmdir(buf.toString());
            buf = new StringBuffer(SRC_PATH);
            buf = buf.append(File.separator);
            buf = buf.append("base");
            Output.rmdir(buf.toString());
        }
        Linker.readme.echoln("<INPUT PHASE>");
        Make.read(new File(Param.HTML_ROOT.get()));
        Linker.readme.echoln("<OUTPUT PHASE>");
        Make.write();
        Linker.readme.output();
        Linker.readme.echoln("All phase ended. Please confirm Readme.html.");
        long time = (new Date().getTime() - start.getTime() + 500L) / 100L;
        Linker.readme.echoln(String.format("Total time: %.1fsec", Float.valueOf((float)time / 10.0f)));
    }
}

