/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.list;


import java.util.*;
import paraselene.*;
import paraselene.tag.*;

/**
 * リスト。UL、OL、DLタグです。
 */
public class List extends Tag {
	private static final long serialVersionUID = 2L;
	/**
	 * リストの種類。
	 */
	public enum Type {
		/**
		 * 順序無しリスト。ulタグ。
		 */
		UNORDERED("ul"),
		/**
		 * 順序付きリスト。olタグ。
		 */
		ORDERED("ol"),
		/**
		 * 定義リスト。dlタグ。
		 */
		DEFINITION("dl");

		private static final long serialVersionUID = 1L;
		String	str;
		private Type( String s ) {
			str = s;
		}

	}

	private Type const_type;
	/**
	 * 種別の取得。
	 * @return 種別。
	 */
	public Type getType() {
		return const_type;
	}

	/**
	 * コンストラクタ。
	 */
	public List( Type type ) {
		super( type.str, false );
		const_type = type;
	}

	protected Tag newReplica() {
		return new List( const_type );
	}

	/**
	 * 項目の取得。
	 * @param type 取得するタグ。nullだと、全種類の項目タグを列挙する。
	 * @return 選択項目の配列。
	 */
	public ListItem[] getItemArray( ListItem.Type type ) {
		Tag[]	tag = getTagArray();
		ArrayList<ListItem>	item = new ArrayList<ListItem>();
		for ( int i = 0; i < tag.length; i++ ) {
			if ( tag[i] instanceof ListItem ) {
				ListItem	obj = (ListItem)tag[i];
				if ( type == null ) {
					item.add( obj );
				}
				else if ( type.str.equals( obj.getName() ) ) {
					item.add( obj );
				}
			}
		}
		return item.toArray( new ListItem[0] );
	}
}

