/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.net.*;
import java.io.*;

/**
 * コメント。
 */
public class Comment extends HTMLPart {
	private static final long serialVersionUID = 1L;
	private String	text;

	private Comment() {}

	/**
	 * コンストラクタ。
	 * @param c コメント。&lt;!-- --&gt;は含めないで下さい。
	 */
	public Comment( String c ) {
		text = c;
	}

	/**
	 * テキスト化。
	 * @param mode 出力モード。
	 * @return 文字列。
	 */
	public String toString( StringMode mode ) {
		StringBuffer	buf = new StringBuffer( "<!--\n" );
		buf = buf.append( text );
		buf = buf.append( "\n-->\n" );
		return buf.toString();
	}

	/**
	 * 複製の作成。
	 * @return 複製。
	 */
	public HTMLPart getReplica() {
		return new Comment( text );
	}

	/**
	 * コメント内容の取得。
	 * @return コメント文字列。
	 */
	public String getComment() {
		return text;
	}
}



