/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.list;


import paraselene.tag.*;

/**
 * リストの項目。LI、DT、DDタグです。
 */
public class ListItem extends Tag {
	private static final long serialVersionUID = 1L;
	/**
	 * リスト項目のタイプ。
	 */
	public enum Type {
		/**
		 * LIタグ。
		 * ULまたはOLタグの中のアイテムです。
		 */
		LIST_ITEM("li"),
		/**
		 * DTタグ。
		 * DLタグのアイテムです。
		 */
		DEFINITION_TERM("dt"),
		/**
		 * DDタグ。
		 * DLタグのアイテムです。
		 */
		DEFINITION_DESCRIPTION("dd");

		private static final long serialVersionUID = 1L;
		String	str;

		private Type( String s ) {
			str = s;
		}
	}

	private Type const_type;
	/**
	 * 種別の取得。
	 * @return 種別。
	 */
	public Type getType() {
		return const_type;
	}

	/**
	 * コンストラクタ。
	 * @param type タイプ。
	 */
	public ListItem( Type type ) {
		super( type.str, false );
		const_type = type;
	}

	/**
	 * コンストラクタ。
	 * @param type タイプ。
	 * @param str 見出し文字列。
	 */
	public ListItem( Type type, String str ) {
		this( type );
		setValueString( str );
	}

	protected Tag newReplica() {
		return new ListItem( const_type );
	}

}



