/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import paraselene.Color;

public class YUV {
    public int y;
    public int u;
    public int v;

    public YUV(int y, int u, int v) {
        this.y = YUV.unsigned_fix(y);
        this.u = YUV.signed_fix(u);
        this.v = YUV.signed_fix(v);
    }

    private static int unsigned_fix(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    private static int signed_fix(int v) {
        if (v < -128) {
            return -128;
        }
        if (v > 127) {
            return 127;
        }
        return v;
    }

    static YUV getYUV(Color c) {
        double[] s = new double[]{c.getRed(), c.getGreen(), c.getBlue()};
        double[] d = new double[]{0.299 * s[0] + 0.587 * s[1] + 0.114 * s[2], -0.169 * s[0] - 0.331 * s[1] + 0.5 * s[2], 0.5 * s[0] - 0.419 * s[1] - 0.081 * s[2]};
        return new YUV((int)d[0], (int)d[1], (int)d[2]);
    }

    void toColor(Color c) {
        double[] s = new double[]{YUV.unsigned_fix(this.y), YUV.signed_fix(this.u), YUV.signed_fix(this.v)};
        double[] d = new double[]{s[0] + 1.402 * s[2], s[0] - 0.344 * s[1] - 0.714 * s[2], s[0] + 1.772 * s[1]};
        c.setColor(YUV.unsigned_fix((int)d[0]), YUV.unsigned_fix((int)d[1]), YUV.unsigned_fix((int)d[2]));
    }
}

