/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import paraselene.Color;

public class HSL {
    public int hue;
    public int saturation;
    public int lightness;

    public HSL(int h, int s, int l) {
        this.hue = HSL.round(h);
        this.saturation = HSL.per(s);
        this.lightness = HSL.per(l);
    }

    private static int round(int r) {
        do {
            if (r < 0) {
                r += 360;
            }
            if (r < 360) continue;
            r -= 360;
        } while (r < 0 || r >= 360);
        return r;
    }

    private static int per(int p) {
        if (p < 0) {
            return 0;
        }
        if (p > 100) {
            return 100;
        }
        return p;
    }

    private static int rgb_to_per(int v) {
        return HSL.per(v * 100 / 256);
    }

    private static int per_to_rgb(int v) {
        if ((v = v * 256 / 100) > 255) {
            v = 255;
        }
        if (v < 0) {
            v = 0;
        }
        return v;
    }

    private static int max(int ... v) {
        int m = v[0];
        for (int i = 1; i < v.length; ++i) {
            if (m >= v[i]) continue;
            m = v[i];
        }
        return m;
    }

    private static int min(int ... v) {
        int m = v[0];
        for (int i = 1; i < v.length; ++i) {
            if (m <= v[i]) continue;
            m = v[i];
        }
        return m;
    }

    private static int toC(int v, int max, int min) {
        return (max - v) / (max - min);
    }

    static HSL getHSL(Color c) {
        int r = HSL.rgb_to_per(c.getRed());
        int g = HSL.rgb_to_per(c.getGreen());
        int b = HSL.rgb_to_per(c.getBlue());
        int max = HSL.max(r, g, b);
        int min = HSL.min(r, g, b);
        int l = (max + min) / 2;
        int h = 0;
        int s = 0;
        if (max != min) {
            s = l > 50 ? (max - min) / (2 - max - min) : (max - min) / (max + min);
            int cr = HSL.toC(r, max, min);
            int cg = HSL.toC(g, max, min);
            int cb = HSL.toC(b, max, min);
            h = r == max ? cb - cg : (g == max ? 2 + cr - cb : 4 + cg - cr);
        }
        return new HSL(h, s, l);
    }

    private static int getH(int h, int max, int min) {
        if ((h = HSL.round(h)) < 60) {
            return min + (max - min) * h / 60;
        }
        if (h < 180) {
            return max;
        }
        if (h < 240) {
            return min + (max - min) * (240 - h) / 60;
        }
        return min;
    }

    void toColor(Color c) {
        int h = HSL.round(this.hue);
        int s = HSL.per(this.saturation);
        int l = HSL.per(this.lightness);
        if (s == 0) {
            l = HSL.per_to_rgb(l);
            c.setColor(l, l, l);
            return;
        }
        int max = l > 50 ? l * (100 - s) + s : l * (100 + s);
        int min = 2 * l - max;
        int r = HSL.per_to_rgb(HSL.getH(h + 120, max, min));
        int g = HSL.per_to_rgb(HSL.getH(h, max, min));
        int b = HSL.per_to_rgb(HSL.getH(h - 120, max, min));
        c.setColor(r, g, b);
    }
}

