/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.form;

import java.util.ArrayList;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.supervisor.Forward;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;
import paraselene.tag.form.Control;
import paraselene.tag.form.SelectItem;
import paraselene.ui.PageHooker;

public class Select
extends Control
implements PageHooker {
    private static final long serialVersionUID = 2L;
    private static final String NAME = "select";
    private static final String MULTI = "multiple";

    public boolean isMultiple() {
        return this.getAttribute(MULTI) != null;
    }

    public void setMultiple(boolean multi_f) {
        if (multi_f) {
            try {
                this.setAttribute(new Attribute(MULTI));
            }
            catch (Exception exception) {}
        } else {
            this.removeAttribute(MULTI);
        }
    }

    public Select() {
        super(NAME, false);
    }

    @Override
    protected Tag newReplica() {
        return this.copy4Replica(new Select());
    }

    private void setup(HTMLPart d) {
        if (!(d instanceof SelectItem)) {
            return;
        }
        SelectItem item = (SelectItem)d;
        item.list = this;
        if (item.isSelected()) {
            this.setValueString(item.getValueString());
        }
    }

    @Override
    public void addHTMLPart(HTMLPart d) {
        super.addHTMLPart(d);
        this.setup(d);
    }

    @Override
    public void addHTMLPart(int idx, HTMLPart d) {
        super.addHTMLPart(idx, d);
        this.setup(d);
    }

    public SelectItem[] getItemArray() {
        Tag[] tag = this.getTagArray();
        ArrayList<SelectItem> item = new ArrayList<SelectItem>();
        for (int i = 0; i < tag.length; ++i) {
            if (!(tag[i] instanceof SelectItem)) continue;
            item.add((SelectItem)tag[i]);
        }
        return item.toArray(new SelectItem[0]);
    }

    @Override
    public String getValueString() {
        SelectItem[] item = this.getItemArray();
        for (int i = 0; i < item.length; ++i) {
            if (!item[i].isSelected()) continue;
            return item[i].getValueString();
        }
        return null;
    }

    public String[] getValueStrings() {
        ArrayList<String> list = new ArrayList<String>();
        SelectItem[] item = this.getItemArray();
        for (int i = 0; i < item.length; ++i) {
            if (!item[i].isSelected()) continue;
            list.add(item[i].getValueString());
        }
        return list.toArray(new String[0]);
    }

    @Override
    public Forward exportToCookie(RequestParameter req, Forward fw, int expiry, boolean ssl_f) {
        String[] val = this.getValueStrings();
        if (val.length == 0) {
            return fw;
        }
        try {
            fw.addCookie(this.makeCookieValue(req, val, expiry, ssl_f));
        }
        catch (Exception e) {
            // empty catch block
        }
        return fw;
    }

    public boolean isSameSet(String[] val) {
        String[] myself = this.getValueStrings();
        if (val.length != myself.length) {
            return false;
        }
        return this.isSubSet(val);
    }

    public boolean isSubSet(String[] val) {
        String[] myself = this.getValueStrings();
        if (val.length > myself.length) {
            return false;
        }
        for (int i = 0; i < val.length; ++i) {
            boolean flag = false;
            for (int j = 0; j < myself.length; ++j) {
                if (val[i] == null) {
                    if (myself[j] == null) {
                        flag = true;
                    }
                } else {
                    flag = val[i].equals(myself[j]);
                }
                if (!flag) continue;
                myself[j] = "\bpara\bselene\b";
                break;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setValueString(String v) {
        SelectItem[] item = this.getItemArray();
        boolean flag = !this.isMultiple();
        for (int i = 0; i < item.length; ++i) {
            if (v == null) {
                item[i].setSelected(false);
                continue;
            }
            if (v.equals(item[i].getValueString())) {
                item[i].setSelected(true);
                continue;
            }
            if (!flag) continue;
            item[i].setSelected(false);
        }
    }

    @Override
    public void importFromCookie(RequestParameter req) {
        if (!this.isEmptyValue()) {
            return;
        }
        try {
            String[] val = (String[])this.getCookieValue(req);
            if (val != null) {
                for (int i = 0; i < val.length; ++i) {
                    this.setValueString(val[i]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void makeSequenceNo(int start, int end) {
        this.removeHTMLPart();
        while (start <= end) {
            String str = Integer.toString(start);
            this.addHTMLPart((HTMLPart)new SelectItem(str, str));
            ++start;
        }
    }

    @Override
    public Forward beforeInput(Page page, RequestParameter req, Forward fw) throws Exception {
        return fw;
    }

    @Override
    public void afterOutput(Page from, Page to, RequestParameter req) throws Exception {
        this.commitDaemon();
    }

    @Override
    public void commitDaemon() {
        if (!this.isAjaxEnable()) {
            return;
        }
        String name = this.getNameAttribute();
        if (name == null) {
            return;
        }
        String id = this.getForm().getIDAttribute();
        SelectItem[] item = this.getItemArray();
        for (int i = 0; i < item.length; ++i) {
            if (!item[i].isSelected()) continue;
            StringBuilder buf = new StringBuilder("paraselene.selected_index('");
            buf = buf.append(id);
            buf = buf.append("','");
            buf = buf.append(name);
            buf = buf.append("',");
            buf = buf.append(Integer.toString(i));
            buf = buf.append(");");
            this.getAssignedPage().addOnLoadScript(buf.toString());
        }
    }
}

